/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.mining.utils;

import codes.cookies.mod.config.categories.mining.MiningCategory;
import codes.cookies.mod.data.profile.ProfileData;
import codes.cookies.mod.data.profile.ProfileStorage;
import codes.cookies.mod.events.api.InventoryContentUpdateEvent;
import codes.cookies.mod.repository.constants.RepositoryConstants;
import codes.cookies.mod.repository.constants.mining.Hotm;
import codes.cookies.mod.utils.SkyblockUtils;
import codes.cookies.mod.utils.exceptions.ExceptionHandler;
import codes.cookies.mod.utils.items.CookiesDataComponentTypes;
import codes.cookies.mod.utils.items.ItemUtils;
import codes.cookies.mod.utils.items.types.HotmDataComponentTypes;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_476;
import net.minecraft.class_5250;
import net.minecraft.class_9290;
import net.minecraft.class_9334;

public class HotmUtils {
    public HotmUtils() {
        ScreenEvents.BEFORE_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (!(screen instanceof class_476)) {
                return;
            }
            class_476 genericContainerScreen = (class_476)screen;
            if (!SkyblockUtils.isCurrentlyInSkyblock()) {
                return;
            }
            if (!genericContainerScreen.method_25440().getString().equals("Heart of the Mountain")) {
                return;
            }
            InventoryContentUpdateEvent.register(genericContainerScreen.method_17577(), ExceptionHandler.wrap(this::updateInventory));
        });
    }

    private void updateInventory(int i, class_1799 itemStack) {
        this.setBaseComponents(itemStack);
        if (MiningCategory.showHotmPerkLevelAsStackSize) {
            this.setPerkLevelAsStackSize(itemStack);
        }
        if (MiningCategory.highlightDisabledHotmPerks) {
            this.setBackgroundColor(itemStack);
        }
        if (MiningCategory.showNext10Cost || MiningCategory.showTotalCost) {
            this.setCost(itemStack);
        }
    }

    private void setBaseComponents(class_1799 itemStack) {
        class_9290 data = (class_9290)ItemUtils.getData(itemStack, class_9334.field_49632);
        if (data == null) {
            return;
        }
        List lines = data.comp_2400();
        if (lines == null || lines.isEmpty()) {
            return;
        }
        String string = ((class_2561)lines.getLast()).getString().toLowerCase(Locale.ROOT);
        boolean unlocked = !string.startsWith("click to unlock") && !string.startsWith("requires");
        int level = this.getLevel((class_2561)lines.getFirst());
        if (level > 0) {
            itemStack.method_57379(HotmDataComponentTypes.HOTM_PERK_LEVEL, (Object)level);
        }
        boolean disabled = this.isDisabled(lines);
        itemStack.method_57379(HotmDataComponentTypes.HOTM_DISABLED, (Object)disabled);
        class_2561 name = (class_2561)ItemUtils.getData(itemStack, class_9334.field_49631);
        if (name == null) {
            return;
        }
        String type = name.getString().toLowerCase(Locale.ROOT).replaceAll(" ", "_").replaceAll("\\W", "");
        itemStack.method_57379(HotmDataComponentTypes.HOTM_PERK_TYPE, (Object)type);
        this.save(type, unlocked ? level : 0, !disabled);
    }

    private void save(String id, int level, boolean enabled) {
        Optional<ProfileData> optionalProfile = ProfileStorage.getCurrentProfile();
        if (optionalProfile.isEmpty()) {
            return;
        }
        ProfileData profileData = optionalProfile.get();
        profileData.getHotmData().save(id, level, enabled);
    }

    private void setPerkLevelAsStackSize(class_1799 itemStack) {
        if (itemStack.method_7909() == class_1802.field_8713) {
            return;
        }
        Integer data = ItemUtils.getData(itemStack, HotmDataComponentTypes.HOTM_PERK_LEVEL);
        if (data == null) {
            return;
        }
        itemStack.method_57379(CookiesDataComponentTypes.CUSTOM_SLOT_TEXT, (Object)String.valueOf(data));
    }

    private void setBackgroundColor(class_1799 itemStack) {
        Boolean data = ItemUtils.getData(itemStack, HotmDataComponentTypes.HOTM_DISABLED);
        if (data == null || !data.booleanValue()) {
            return;
        }
        itemStack.method_57379(CookiesDataComponentTypes.OVERRIDE_RENDER_ITEM, (Object)new class_1799((class_1935)class_1802.field_8725));
    }

    private void setCost(class_1799 itemStack) {
        NumberFormat numberFormat = DecimalFormat.getNumberInstance(Locale.ENGLISH);
        class_9290 data = (class_9290)ItemUtils.getData(itemStack, class_9334.field_49632);
        if (data == null || data.comp_2400().isEmpty()) {
            return;
        }
        String perkType = ItemUtils.getData(itemStack, HotmDataComponentTypes.HOTM_PERK_TYPE);
        Integer perkLevel = ItemUtils.getData(itemStack, HotmDataComponentTypes.HOTM_PERK_LEVEL);
        if (perkType == null || perkLevel == null) {
            return;
        }
        ArrayList<class_5250> lines = new ArrayList<class_5250>(data.comp_2400());
        for (int index = 0; index < lines.size(); ++index) {
            int amount;
            Hotm.Perk perk;
            class_2561 current = (class_2561)lines.get(index);
            String textCurrent = current.getString().trim();
            if (!textCurrent.equals("Cost")) continue;
            index += 2;
            if (MiningCategory.showNext10Cost) {
                lines.add(index++, class_2561.method_43473());
                lines.add(index++, class_2561.method_43471((String)"cookies.hotm_utils.cost_next_10").method_27692(class_124.field_1080));
                perk = RepositoryConstants.hotm.getPerk(perkType);
                if (perk == null) {
                    return;
                }
                if (!perk.isOverMax(perkLevel + 10)) {
                    amount = perk.calculateNextN(10, perkLevel);
                    lines.add(index++, class_2561.method_43470((String)"%s ".formatted(numberFormat.format(amount))).method_27693(perk.powderType().getName()).method_27692(perk.powderType().getFormatting()));
                }
            }
            if (!MiningCategory.showTotalCost) break;
            lines.add(index++, class_2561.method_43473());
            lines.add(index++, class_2561.method_43471((String)"cookies.hotm_utils.cost_total").method_27692(class_124.field_1080));
            perk = RepositoryConstants.hotm.getPerk(perkType);
            if (perk == null) {
                return;
            }
            amount = perk.calculateTotal(perkLevel);
            lines.add(index, class_2561.method_43470((String)"%s ".formatted(numberFormat.format(amount))).method_27693(perk.powderType().getName()).method_27692(perk.powderType().getFormatting()));
            break;
        }
        itemStack.method_57379(CookiesDataComponentTypes.CUSTOM_LORE, lines);
    }

    private int getLevel(class_2561 text) {
        String line = text.getString().trim();
        if (!line.startsWith("Level")) {
            return 0;
        }
        String perkLevel = line.split("/")[0].replaceAll("\\D", "");
        return Integer.parseInt(perkLevel);
    }

    private boolean isDisabled(List<class_2561> lines) {
        for (class_2561 line : lines) {
            if (!line.getString().trim().equalsIgnoreCase("disabled")) continue;
            return true;
        }
        return false;
    }
}

