/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.misc;

import codes.cookies.mod.config.categories.PartyCommands;
import codes.cookies.mod.events.ChatMessageEvents;
import codes.cookies.mod.utils.cookies.CookiesUtils;
import codes.cookies.mod.utils.skyblock.ChatUtils;
import codes.cookies.mod.utils.skyblock.PartyUtils;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class PartyCommandsFeature {
    private static final Random random = new Random();
    private static final Map<Predicate<String>, PartyCommand> commandMap = Map.ofEntries(Map.entry(command -> command.equals("ptme"), new PartyCommand(() -> PartyCommandsFeature.shouldRunCommand("ptme"), (command, message) -> {
        String sender = PartyCommandsFeature.getSender(message);
        if (sender.equals(class_310.method_1551().method_1548().method_1676())) {
            return;
        }
        CookiesUtils.sendCommand("p transfer " + sender);
    })), Map.entry(command -> command.equals("warp"), new PartyCommand(() -> PartyCommandsFeature.shouldRunCommand("warp"), (command, message) -> CookiesUtils.sendCommand("p warp"))), Map.entry(command -> command.matches("f[1-7]|m[1-7]|t[1-5]"), new PartyCommand(() -> PartyCommandsFeature.shouldRunCommand("joininstance"), (command, message) -> {
        StringBuilder joinInstanceCommand = new StringBuilder("joininstance ");
        switch (command.charAt(0)) {
            case 'f': {
                joinInstanceCommand.append("CATACOMBS_FLOOR_");
                break;
            }
            case 'm': {
                joinInstanceCommand.append("MASTER_CATACOMBS_FLOOR_");
                break;
            }
            case 't': {
                joinInstanceCommand.append("KUUDRA_");
                switch (command.charAt(1)) {
                    case '1': {
                        joinInstanceCommand.append("BASIC");
                        break;
                    }
                    case '2': {
                        joinInstanceCommand.append("HOT");
                        break;
                    }
                    case '3': {
                        joinInstanceCommand.append("BURNING");
                        break;
                    }
                    case '4': {
                        joinInstanceCommand.append("FIERY");
                        break;
                    }
                    case '5': {
                        joinInstanceCommand.append("INFERNAL");
                    }
                }
                CookiesUtils.sendCommand(joinInstanceCommand.toString());
                return;
            }
        }
        switch (command.charAt(1)) {
            case '1': {
                joinInstanceCommand.append("ONE");
                break;
            }
            case '2': {
                joinInstanceCommand.append("TWO");
                break;
            }
            case '3': {
                joinInstanceCommand.append("THREE");
                break;
            }
            case '4': {
                joinInstanceCommand.append("FOUR");
                break;
            }
            case '5': {
                joinInstanceCommand.append("FIVE");
                break;
            }
            case '6': {
                joinInstanceCommand.append("SIX");
                break;
            }
            case '7': {
                joinInstanceCommand.append("SEVEN");
            }
        }
        CookiesUtils.sendCommand(joinInstanceCommand.toString());
    })), Map.entry(command -> command.startsWith("dt"), new DownTimeCommand(() -> PartyCommandsFeature.shouldRunCommand("dt"))), Map.entry(command -> command.equals("cf"), new PartyCommand(() -> PartyCommandsFeature.shouldRunCommand("cf"), (command, message) -> {
        if (random.nextBoolean()) {
            ChatUtils.sendPartyMessage("HEADS!");
        } else {
            ChatUtils.sendPartyMessage("TAILS!");
        }
    })));

    public static void register() {
        ChatMessageEvents.BEFORE_MODIFY.register(PartyCommandsFeature::handleChat);
    }

    private static boolean shouldRunCommand(String partyCommand) {
        PartyUtils.request();
        Optional<class_746> player = CookiesUtils.getPlayer();
        return PartyCommands.isCommandEnabled(partyCommand) && player.filter(clientPlayerEntity -> PartyUtils.isInParty() && PartyUtils.getPartyLeader().equals(clientPlayerEntity.method_5667())).isPresent();
    }

    private static void handleChat(class_2561 text, boolean b) {
        BiConsumer<String, String> action;
        if (b) {
            return;
        }
        String message = text.getString();
        if (!message.startsWith("\u00a79Party \u00a78> ")) {
            return;
        }
        String commandString = CookiesUtils.stripColor(message.substring(message.indexOf(": !") + 3).trim());
        Optional<Map.Entry> command = commandMap.entrySet().stream().filter(commandEntry -> ((Predicate)commandEntry.getKey()).test(commandString)).findFirst();
        if (command.isPresent() && ((PartyCommand)command.get().getValue()).getPredicate().get().booleanValue() && (action = ((PartyCommand)command.get().getValue()).getAction()) != null) {
            action.accept(commandString, message);
        }
    }

    private static String getSender(String message) {
        String sender = message.substring(message.indexOf("\u00a78> ") + 4, message.indexOf(":")).trim();
        int rank = sender.indexOf("]");
        if (rank != -1) {
            sender = sender.substring(rank + 1).trim();
        }
        sender = CookiesUtils.stripColor(sender);
        return sender;
    }

    public static class PartyCommand {
        private final Supplier<Boolean> predicate;
        protected BiConsumer<String, String> action;

        public PartyCommand(Supplier<Boolean> predicate, BiConsumer<String, String> action) {
            this.predicate = predicate;
            this.action = action;
        }

        @Generated
        public Supplier<Boolean> getPredicate() {
            return this.predicate;
        }

        @Generated
        public BiConsumer<String, String> getAction() {
            return this.action;
        }
    }

    public static class DownTimeCommand
    extends PartyCommand {
        private final ArrayList<DownTimeAction> downTimesThisInstance = new ArrayList();

        public DownTimeCommand(Supplier<Boolean> predicate) {
            super(predicate, null);
            ChatMessageEvents.BEFORE_MODIFY.register((text, b) -> {
                if (b.booleanValue()) {
                    return;
                }
                String message = CookiesUtils.stripColor(text.getString());
                if (!message.matches(".*> EXTRA STATS <.*")) {
                    return;
                }
                this.onInstanceOver();
            });
            this.action = this::runAction;
        }

        private void runAction(String command, String message) {
            String sender = PartyCommandsFeature.getSender(message);
            if (this.downTimesThisInstance.stream().anyMatch(x -> x.requester.equals(sender))) {
                ChatUtils.sendPartyMessage(sender + " has already requested down time.");
                return;
            }
            String[] split = command.split(" ");
            switch (split.length) {
                case 1: {
                    this.downTimesThisInstance.add(new DownTimeAction("Not Specified", sender, null));
                    break;
                }
                case 2: {
                    this.downTimesThisInstance.add(new DownTimeAction(split[1], sender, null));
                    break;
                }
                case 3: {
                    this.downTimesThisInstance.add(new DownTimeAction(split[1], sender, split[2]));
                }
            }
            ChatUtils.sendPartyMessage("Down time requested by " + sender);
        }

        private void onInstanceOver() {
            this.downTimesThisInstance.forEach(DownTimeAction::onInstanceOver);
            this.downTimesThisInstance.clear();
        }

        public static class DownTimeAction {
            private final String reason;
            private final String requester;
            private final String duration;

            public DownTimeAction(String reason, String requester, String duration) {
                this.reason = reason;
                this.requester = requester;
                this.duration = duration;
            }

            public void onInstanceOver() {
                StringBuilder message = new StringBuilder("Down time requested by " + this.requester);
                if (this.duration != null) {
                    message.append(" for ").append(this.duration);
                }
                if (this.reason != null) {
                    message.append(" because: ").append(this.reason);
                }
                if (PartyCommands.sendDowntimePartyMessage) {
                    ChatUtils.sendPartyMessage(message.toString());
                } else {
                    CookiesUtils.sendMessage(message.toString());
                }
            }
        }
    }
}

