/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.misc.items;

import codes.cookies.mod.config.categories.HelpersCategory;
import codes.cookies.mod.data.profile.ProfileData;
import codes.cookies.mod.data.profile.ProfileStorage;
import codes.cookies.mod.data.profile.profile.GlobalProfileData;
import codes.cookies.mod.data.profile.profile.IslandChestStorage;
import codes.cookies.mod.utils.dev.FunctionUtils;
import codes.cookies.mod.utils.skyblock.LocationUtils;
import java.util.Optional;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.event.client.player.ClientPlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_4732;
import net.minecraft.class_5250;
import net.minecraft.class_638;
import net.minecraft.class_7417;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;

public class ChestTracker {
    private class_2338 first;
    private class_2338 second;
    private static final int SLOTS_IN_ONE_CHEST = 27;

    public ChestTracker() {
        UseBlockCallback.EVENT.register(this::blockClicked);
        ClientPlayerBlockBreakEvents.AFTER.register(this::blockBreak);
        ScreenEvents.BEFORE_INIT.register(this::openScreen);
    }

    private class_1269 blockClicked(class_1657 playerEntity, class_1937 world, class_1268 hand, class_3965 blockHitResult) {
        this.resetCoords();
        if (!HelpersCategory.chestTracker) {
            return class_1269.field_5811;
        }
        if (!LocationUtils.Island.PRIVATE_ISLAND.isActive()) {
            return class_1269.field_5811;
        }
        if (blockHitResult.method_17783() != class_239.class_240.field_1332) {
            return class_1269.field_5811;
        }
        class_2680 blockState = world.method_8320(blockHitResult.method_17777());
        class_2248 block = blockState.method_26204();
        if (block != class_2246.field_10034 && block != class_2246.field_10380) {
            return class_1269.field_5811;
        }
        this.first = blockHitResult.method_17777();
        class_2745 chestType = (class_2745)blockState.method_11654((class_2769)class_2741.field_12506);
        class_4732.class_4733 doubleBlockType = ChestTracker.getDoubleBlockType(blockState);
        if (chestType != class_2745.field_12569) {
            class_2338 diff;
            switch ((class_2350)blockState.method_11654((class_2769)class_2741.field_12481)) {
                case field_11034: {
                    class_2338 class_23382 = new class_2338(0, 0, 1);
                    break;
                }
                case field_11039: {
                    class_2338 class_23382 = new class_2338(0, 0, -1);
                    break;
                }
                case field_11043: {
                    class_2338 class_23382 = new class_2338(1, 0, 0);
                    break;
                }
                case field_11035: {
                    class_2338 class_23382 = new class_2338(-1, 0, 0);
                    break;
                }
                default: {
                    class_2338 class_23382 = diff = class_2338.field_10980;
                }
            }
            if (chestType != class_2745.field_12574) {
                diff = diff.method_35830(-1);
            }
            class_2338 doubleChestPosition = this.first.method_10081((class_2382)diff);
            if (doubleBlockType == class_4732.class_4733.field_21784) {
                this.second = doubleChestPosition;
            } else {
                this.second = this.first;
                this.first = doubleChestPosition;
            }
        }
        return class_1269.field_5811;
    }

    public static class_4732.class_4733 getDoubleBlockType(class_2680 state) {
        class_2745 chestType = (class_2745)state.method_11654((class_2769)class_2741.field_12506);
        if (chestType == class_2745.field_12569) {
            return class_4732.class_4733.field_21783;
        }
        if (chestType == class_2745.field_12571) {
            return class_4732.class_4733.field_21784;
        }
        return class_4732.class_4733.field_21785;
    }

    private void blockBreak(class_638 clientWorld, class_746 clientPlayerEntity, class_2338 blockPos, class_2680 blockState) {
        if (!LocationUtils.Island.PRIVATE_ISLAND.isActive()) {
            return;
        }
        if (!blockState.method_27852(class_2246.field_10034) && !blockState.method_27852(class_2246.field_10380)) {
            return;
        }
        ProfileStorage.getCurrentProfile().flatMap(ProfileData::getGlobalProfileData).map(GlobalProfileData::getIslandStorage).map(FunctionUtils.function(IslandChestStorage::removeBlock)).orElseGet(FunctionUtils::noOp).accept(blockPos);
    }

    private void openScreen(class_310 minecraftClient, class_437 screen, int scaledWidth, int scaledHeight) {
        if (!(screen instanceof class_465)) {
            return;
        }
        if (!HelpersCategory.chestTracker) {
            return;
        }
        if (!LocationUtils.Island.PRIVATE_ISLAND.isActive()) {
            return;
        }
        if (this.first == null && this.second == null) {
            return;
        }
        class_2561 class_25612 = screen.method_25440();
        if (!(class_25612 instanceof class_5250)) {
            return;
        }
        class_5250 mutable = (class_5250)class_25612;
        class_7417 class_74172 = mutable.method_10851();
        if (!(class_74172 instanceof class_2588)) {
            return;
        }
        class_2588 translatableText = (class_2588)class_74172;
        String translationKey = translatableText.method_11022();
        if (!translationKey.startsWith("container.chest")) {
            return;
        }
        ScreenEvents.remove((class_437)screen).register(this::saveScreen);
    }

    private void resetCoords() {
        this.first = null;
        this.second = null;
    }

    private void saveScreen(class_437 screen) {
        class_465 handledScreen = (class_465)screen;
        Optional<IslandChestStorage> currentProfile = ProfileStorage.getCurrentProfile().flatMap(ProfileData::getGlobalProfileData).map(GlobalProfileData::getIslandStorage);
        if (currentProfile.isEmpty()) {
            return;
        }
        IslandChestStorage islandStorage = currentProfile.get();
        islandStorage.removeBlock(this.first);
        islandStorage.removeBlock(this.second);
        for (class_1735 slot : handledScreen.method_17577().field_7761) {
            if (slot.field_7871 instanceof class_1661 || slot.method_7677().method_7960()) continue;
            this.saveItem(islandStorage, slot, this.getBlockPos(slot.field_7874));
        }
        this.postUpdates(islandStorage);
    }

    private void postUpdates(IslandChestStorage islandStorage) {
        islandStorage.sendEvent(this.first, this.second);
        islandStorage.sendEvent(this.second, this.first);
    }

    private void saveItem(IslandChestStorage islandStorage, class_1735 slot, @NotNull class_2338 blockPos) {
        islandStorage.save(blockPos, this.getOtherPos(slot.field_7874), slot.method_7677(), this.getSlotForChest(slot.field_7874));
    }

    public int getSlotForChest(int slot) {
        if (slot >= 27) {
            return slot - 27;
        }
        return slot;
    }

    public class_2338 getBlockPos(int slot) {
        if (slot >= 27) {
            return this.second;
        }
        return this.first;
    }

    public class_2338 getOtherPos(int slot) {
        if (slot >= 27) {
            return this.first;
        }
        return this.second;
    }
}

