/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.misc.items;

import codes.cookies.mod.config.categories.MiscCategory;
import codes.cookies.mod.generated.utils.ItemAccessor;
import codes.cookies.mod.repository.RepositoryItem;
import codes.cookies.mod.utils.SkyblockUtils;
import codes.cookies.mod.utils.items.CookiesDataComponentTypes;
import codes.cookies.mod.utils.items.ItemUtils;
import codes.cookies.mod.utils.items.Value;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class ItemStats {
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("uuuu-MM-dd' 'hh:mm").withZone(ZoneId.systemDefault());

    public static void register() {
        ItemTooltipCallback.EVENT.register(ItemStats::modifyTooltip);
    }

    private static void modifyTooltip(class_1799 itemStack, class_1792.class_9635 tooltipContext, class_1836 tooltipType, List<class_2561> texts) {
        Instant time;
        if (!SkyblockUtils.isCurrentlyInSkyblock()) {
            return;
        }
        Value<String> stringValue = ItemAccessor.skyblockId(itemStack);
        if (stringValue.getAsOptional().isEmpty()) {
            return;
        }
        ArrayList<class_2561> list = new ArrayList<class_2561>();
        RepositoryItem repositoryItem = ItemUtils.getData(itemStack, CookiesDataComponentTypes.REPOSITORY_ITEM);
        if (MiscCategory.showItemCreationDate && (time = ItemUtils.getData(itemStack, CookiesDataComponentTypes.TIMESTAMP)) != null) {
            list.add((class_2561)class_2561.method_43471((String)"cookies.item_stats.value.obtained").method_27693(": %s".formatted(dateTimeFormatter.format(time))).method_27692(class_124.field_1076));
        }
        if (MiscCategory.showItemNpcValue && repositoryItem != null && repositoryItem.getValue() > 0.0) {
            ItemStats.addValue(itemStack, repositoryItem.getValue(), list, "cookies.item_stats.value.coins");
        }
        if (MiscCategory.showItemNpcValue && repositoryItem != null && repositoryItem.getMotesValue() > 0.0) {
            ItemStats.addValue(itemStack, repositoryItem.getMotesValue(), list, "cookies.item_stats.value.motes");
        }
        if (!list.isEmpty()) {
            texts.add((class_2561)class_2561.method_43473());
        }
        texts.addAll(list);
    }

    private static void addValue(class_1799 itemStack, double value, List<class_2561> list, String key) {
        class_5250 formatted = class_2561.method_43471((String)key).method_27693(": ").method_27692(class_124.field_1076);
        formatted.method_10852((class_2561)class_2561.method_43470((String)String.valueOf(value * (double)itemStack.method_7947())).method_27692(class_124.field_1065));
        if (itemStack.method_7947() > 1) {
            formatted.method_10852((class_2561)class_2561.method_43470((String)" (%s)".formatted(value)).method_27692(class_124.field_1063));
        }
        list.add((class_2561)formatted);
    }
}

