/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.misc.items;

import codes.cookies.mod.data.profile.ProfileData;
import codes.cookies.mod.data.profile.ProfileStorage;
import codes.cookies.mod.events.api.InventoryContentUpdateEvent;
import codes.cookies.mod.repository.RepositoryItem;
import codes.cookies.mod.utils.SkyblockUtils;
import codes.cookies.mod.utils.dev.DevUtils;
import codes.cookies.mod.utils.items.CookiesDataComponentTypes;
import codes.cookies.mod.utils.items.ItemUtils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_476;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import org.intellij.lang.annotations.RegExp;

public class SackInventoryTracker {
    private static final String LOGGER_KEY = "SackInventoryTracker";
    @RegExp
    private static final String GEMSTONE_PATTER = "(?:Rough|Flawed|Fine): ([\\d,]+) \\(.*\\)";
    private int lastUpdated = 0;
    private String lastSack = "";

    public SackInventoryTracker() {
        ScreenEvents.AFTER_INIT.register(this::afterInitScreen);
    }

    private void afterInitScreen(class_310 minecraftClient, class_437 screen, int scaledWidth, int scaledHeight) {
        if (!(screen instanceof class_476)) {
            return;
        }
        class_476 genericContainerScreen = (class_476)screen;
        if (!SkyblockUtils.isCurrentlyInSkyblock()) {
            return;
        }
        if (!genericContainerScreen.method_25440().getString().contains("Sack")) {
            return;
        }
        if (genericContainerScreen.method_25440().getString().equalsIgnoreCase("Sack of Sacks")) {
            return;
        }
        if (Objects.equals(this.lastSack, genericContainerScreen.method_25440().getString())) {
            return;
        }
        this.lastSack = genericContainerScreen.method_25440().getString();
        this.lastUpdated = 0;
        InventoryContentUpdateEvent.register(genericContainerScreen.method_17577(), this::update);
    }

    private void update(int i, class_1799 itemStack) {
        if (this.lastUpdated > i) {
            return;
        }
        if (itemStack.method_7909() == class_1802.field_8157) {
            return;
        }
        this.saveItem(itemStack);
        this.lastUpdated = i;
    }

    private void saveItem(class_1799 stack) {
        BiConsumer<class_1799, List> consumer;
        Optional loreComponent = stack.method_57380().method_57845(class_9334.field_49632);
        if (loreComponent == null || loreComponent.isEmpty()) {
            return;
        }
        class_9290 lore = (class_9290)loreComponent.get();
        List lines = lore.comp_2400();
        if (lines.size() < 3) {
            DevUtils.log(LOGGER_KEY, "Item description to small, skipping!", new Object[0]);
            return;
        }
        class_2561 first = (class_2561)lines.getFirst();
        switch (first.getString()) {
            case "Gemstones": {
                BiConsumer<class_1799, List> biConsumer = this::saveGemstoneSackItem;
                break;
            }
            default: {
                BiConsumer<class_1799, List> biConsumer = consumer = this::saveDefaultSackItem;
            }
        }
        if (!((class_2561)lines.getLast()).getString().equalsIgnoreCase("Click to pickup!") && !((class_2561)lines.getLast()).getString().equals("Empty sack!")) {
            return;
        }
        consumer.accept(stack, lines);
    }

    private void saveGemstoneSackItem(class_1799 stack, List<class_2561> lines) {
        if (lines.size() < 9) {
            return;
        }
        String rough = lines.get(2).getString().trim();
        String flawed = lines.get(3).getString().trim();
        String fine = lines.get(4).getString().trim();
        if (!(rough.matches(GEMSTONE_PATTER) && flawed.matches(GEMSTONE_PATTER) && fine.matches(GEMSTONE_PATTER))) {
            DevUtils.log(LOGGER_KEY, "One or more don't match the regex!", new Object[0]);
            return;
        }
        int roughAmount = Integer.parseInt(rough.replaceAll(GEMSTONE_PATTER, "$1").replaceAll("\\D", ""));
        int flawedAmount = Integer.parseInt(flawed.replaceAll(GEMSTONE_PATTER, "$1").replaceAll("\\D", ""));
        int fineAmount = Integer.parseInt(fine.replaceAll(GEMSTONE_PATTER, "$1").replaceAll("\\D", ""));
        String internalId = ItemUtils.getData(stack, CookiesDataComponentTypes.SKYBLOCK_ID);
        ProfileStorage.getCurrentProfile().ifPresent(profileData -> {
            this.set((ProfileData)profileData, RepositoryItem.of(internalId), roughAmount);
            this.set((ProfileData)profileData, RepositoryItem.of(internalId.replace("ROUGH", "FLAWED")), flawedAmount);
            this.set((ProfileData)profileData, RepositoryItem.of(internalId.replace("ROUGH", "FINE")), fineAmount);
        });
    }

    private void saveDefaultSackItem(class_1799 stack, List<class_2561> lines) {
        class_2561 storedLine = lines.get(2);
        String storedString = storedLine.getString();
        String count = storedString.replaceAll("Stored: ([\\d,]+)/\\d+.*", "$1").replaceAll("\\D", "");
        if (count.isEmpty()) {
            DevUtils.log(LOGGER_KEY, "No count found, skipping!", new Object[0]);
            return;
        }
        int amount = Integer.parseInt(count);
        RepositoryItem item = ItemUtils.getData(stack, CookiesDataComponentTypes.REPOSITORY_ITEM);
        if (item == null) {
            DevUtils.log(LOGGER_KEY, "Couldn't find item with id %s", ItemUtils.getData(stack, CookiesDataComponentTypes.SKYBLOCK_ID));
            return;
        }
        ProfileStorage.getCurrentProfile().ifPresent(profileData -> this.set((ProfileData)profileData, item, amount));
    }

    private void set(ProfileData profileData, RepositoryItem repositoryItem, int amount) {
        DevUtils.log(LOGGER_KEY, "Setting %s to %s", repositoryItem.getInternalId(), amount);
        profileData.getSackTracker().set(repositoryItem, amount);
    }
}

