/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.misc.items;

import codes.cookies.mod.data.profile.ProfileData;
import codes.cookies.mod.data.profile.ProfileStorage;
import codes.cookies.mod.data.profile.sub.SackTracker;
import codes.cookies.mod.repository.RepositoryItem;
import codes.cookies.mod.utils.SkyblockUtils;
import codes.cookies.mod.utils.dev.DevUtils;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.minecraft.class_2561;
import net.minecraft.class_2568;

public class SackTrackerListener {
    private static final String LOGGER_KEY = "SackTrackerListener";
    private static final Pattern pattern = Pattern.compile("^ *([+-][\\d,]+)(.+?)\\(.*\\) *$", 8);

    public SackTrackerListener() {
        ClientReceiveMessageEvents.GAME.register(this::receiveMessage);
    }

    private void receiveMessage(class_2561 text, boolean b) {
        if (!SkyblockUtils.isCurrentlyInSkyblock()) {
            return;
        }
        if (b) {
            return;
        }
        String content = text.getString();
        if (!content.startsWith("[Sacks]")) {
            return;
        }
        Optional<ProfileData> currentProfile = ProfileStorage.getCurrentProfile();
        if (currentProfile.isEmpty()) {
            DevUtils.log(LOGGER_KEY, "No active profile", new Object[0]);
            return;
        }
        class_2568 add = null;
        class_2568 remove = null;
        for (class_2561 sibling : text.method_10855()) {
            class_2568 hoverEvent = sibling.method_10866().method_10969();
            if (hoverEvent == null || !hoverEvent.method_10892().equals(class_2568.class_5247.field_24342)) continue;
            class_2561 value = (class_2561)hoverEvent.method_10891(class_2568.class_5247.field_24342);
            if (value == null) {
                return;
            }
            String eventContent = value.getString();
            if (eventContent.contains("Added items:") && add == null) {
                add = hoverEvent;
                continue;
            }
            if (!eventContent.contains("Removed items:") || remove != null) continue;
            remove = hoverEvent;
        }
        DevUtils.log(LOGGER_KEY, "Add event: %s", add == null ? "empty" : "found");
        if (add != null) {
            this.parse(add, currentProfile.get().getSackTracker());
        }
        DevUtils.log(LOGGER_KEY, "Remove event: %s", remove == null ? "empty" : "found");
        if (remove != null) {
            this.parse(remove, currentProfile.get().getSackTracker());
        }
    }

    private void parse(class_2568 hoverEvent, SackTracker sackTracker) {
        class_2561 value = (class_2561)hoverEvent.method_10891(class_2568.class_5247.field_24342);
        if (value != null) {
            String content = value.getString();
            Matcher matcher = pattern.matcher(content);
            while (matcher.find()) {
                int count;
                try {
                    count = Integer.parseInt(matcher.group(1).replaceAll("[^+\\-\\d]", ""));
                }
                catch (NumberFormatException e) {
                    continue;
                }
                String name = matcher.group(2).trim();
                Optional<RepositoryItem> ofName = RepositoryItem.ofName(name);
                if (ofName.isEmpty()) {
                    DevUtils.log(LOGGER_KEY, "No such item: %s", name);
                    continue;
                }
                RepositoryItem repositoryItem = ofName.get();
                sackTracker.modify(repositoryItem, count);
                DevUtils.log(LOGGER_KEY, "Modified item %s, delta: %d", repositoryItem.getInternalId(), count);
            }
        }
    }
}

