/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.misc.items;

import codes.cookies.mod.data.profile.ProfileData;
import codes.cookies.mod.data.profile.ProfileStorage;
import codes.cookies.mod.data.profile.sub.StorageData;
import codes.cookies.mod.utils.SkyblockUtils;
import codes.cookies.mod.utils.dev.DevUtils;
import codes.cookies.mod.utils.exceptions.ExceptionHandler;
import java.util.ArrayList;
import java.util.Optional;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_1707;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_437;
import net.minecraft.class_476;

public class StorageTracker {
    private static final String LOGGER_KEY = "StorageTracker";
    private String lastTitle;

    public StorageTracker() {
        ScreenEvents.AFTER_INIT.register(this::afterInitScreen);
    }

    private void afterInitScreen(class_310 minecraftClient, class_437 screen, int scaledWidth, int scaledHeight) {
        if (!(screen instanceof class_476)) {
            return;
        }
        class_476 genericContainerScreen = (class_476)screen;
        if (!SkyblockUtils.isCurrentlyInSkyblock()) {
            return;
        }
        if (!genericContainerScreen.method_25440().getString().startsWith("Ender Chest (") && !genericContainerScreen.method_25440().getString().contains("Backpack\u00a7r (Slot #")) {
            return;
        }
        this.lastTitle = genericContainerScreen.method_25440().getString();
        ScreenEvents.remove((class_437)screen).register((Object)ExceptionHandler.wrap(this::remove));
    }

    private void remove(class_437 screen) {
        class_476 genericContainerScreen = (class_476)screen;
        DevUtils.log(LOGGER_KEY, "Registered removing of storage inventory!", new Object[0]);
        ArrayList<class_3545<Integer, class_1799>> slots = new ArrayList<class_3545<Integer, class_1799>>();
        for (class_1735 slot : ((class_1707)genericContainerScreen.method_17577()).field_7761) {
            if (slot.field_7871 == class_310.method_1551().field_1724.method_31548() || !slot.method_7681() && (slot.method_34266() + 1) % 9 != 0 || slot.method_34266() <= 8) continue;
            slots.add(new class_3545((Object)(slot.method_34266() - 9), (Object)slot.method_7677()));
        }
        Optional<ProfileData> currentProfile = ProfileStorage.getCurrentProfile();
        if (currentProfile.isEmpty()) {
            return;
        }
        String literalTitle = this.lastTitle;
        this.lastTitle = null;
        boolean isEnderChest = literalTitle.startsWith("Ender Chest");
        int page = isEnderChest ? Integer.parseInt(literalTitle.substring(13, 14)) : Integer.parseInt(literalTitle.replaceAll("\\D", ""));
        currentProfile.get().getStorageData().saveItems(slots, page - 1, isEnderChest ? StorageData.StorageLocation.ENDER_CHEST : StorageData.StorageLocation.BACKPACK);
    }
}

