/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.misc.timer;

import codes.cookies.mod.config.categories.MiscCategory;
import codes.cookies.mod.data.profile.ProfileStorage;
import codes.cookies.mod.features.misc.timer.SbEntityToast;
import codes.cookies.mod.features.misc.timer.Timer;
import codes.cookies.mod.utils.cookies.CookiesUtils;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class FearTimer
extends Timer {
    private static final SbEntityToast.ImageData DATA = new SbEntityToast.ImageData(12, 25, 10, 4, class_2960.method_60655((String)"cookies-mod", (String)"textures/mobs/primal_fear.png"));
    private long lastFearSpawnedAt = -1L;

    public FearTimer() {
        super(MiscCategory.primalFear, "fear");
    }

    @Override
    public void onChatMessage(String message) {
        if (message.equals("FEAR. A Primal Fear has been summoned!")) {
            this.lastFearSpawnedAt = System.currentTimeMillis();
            this.hasBeenAlerted = false;
        }
    }

    private int getTimeToWait() {
        return (int)(360.0 - 3.0 * this.getFear());
    }

    private double getFear() {
        return ProfileStorage.getCurrentProfile().map(profile -> profile.getProfileStats().getStat("fear")).map(optionalDouble -> optionalDouble.orElse(0.0)).orElse(0.0);
    }

    @Override
    public class_2561 getNotificationMessage() {
        return class_2561.method_43470((String)("Primal fear in " + this.getTime() + "s!")).method_27692(class_124.field_1054);
    }

    @Override
    public class_2561 getChatMessage() {
        return CookiesUtils.createPrefix(-5688356).method_27693("You can spawn a primal fear soon! (10s)");
    }

    @Override
    public int getTime() {
        int timeDelta = (int)((System.currentTimeMillis() - this.lastFearSpawnedAt) / 1000L);
        return this.getTimeToWait() - timeDelta;
    }

    @Override
    SbEntityToast.ImageData getData() {
        return DATA;
    }
}

