/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.misc.timer;

import codes.cookies.mod.features.misc.timer.FearTimer;
import codes.cookies.mod.features.misc.timer.PestTimer;
import codes.cookies.mod.features.misc.timer.Timer;
import codes.cookies.mod.utils.cookies.CookiesUtils;
import codes.cookies.mod.utils.dev.DevUtils;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_9779;

public class NotificationManager {
    private static final class_2960 DEBUG = DevUtils.createIdentifier("timer/enable_debug");
    static List<Timer> timers = new ArrayList<Timer>();

    public static void register() {
        ClientTickEvents.END_CLIENT_TICK.register(NotificationManager::afterTick);
        HudRenderCallback.EVENT.register(NotificationManager::debugRendering);
        ClientReceiveMessageEvents.ALLOW_GAME.register(NotificationManager::onMessage);
        timers = List.of(new FearTimer(), new PestTimer());
    }

    private static void debugRendering(class_332 drawContext, class_9779 renderTickCounter) {
        if (DevUtils.isDisabled(DEBUG)) {
            return;
        }
        int y = 0;
        for (Timer timer : timers) {
            if (!timer.getDebug().isPresent()) continue;
            String s = timer.getDebug().get();
            List orderedTexts = class_310.method_1551().field_1772.method_1728((class_5348)class_2561.method_43470((String)s), 200);
            for (class_5481 orderedText : orderedTexts) {
                drawContext.method_51430(class_310.method_1551().field_1772, orderedText, 3, 20 + y++ * 10, -1, true);
            }
        }
    }

    private static boolean onMessage(class_2561 text, boolean overlay) {
        String string = text.getString();
        String literalMessage = CookiesUtils.stripColor(string).trim();
        for (Timer timer : timers) {
            if (timer.isDeactivated()) continue;
            timer.onChatMessage(literalMessage);
        }
        return true;
    }

    private static void afterTick(class_310 minecraftClient) {
        for (Timer timer : timers) {
            int time;
            if (timer.isDeactivated() || (time = timer.getTime()) > timer.getAlertTime() || timer.hasBeenAlerted) continue;
            timer.alert();
        }
    }

    public static enum NotificationType {
        CHAT,
        TOAST,
        BOTH,
        NONE;

    }
}

