/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.misc.timer;

import codes.cookies.mod.config.categories.FarmingCategory;
import codes.cookies.mod.config.categories.objects.PestTimerObject;
import codes.cookies.mod.data.profile.ProfileData;
import codes.cookies.mod.data.profile.ProfileStorage;
import codes.cookies.mod.data.profile.sub.EquipmentData;
import codes.cookies.mod.data.profile.sub.PlotData;
import codes.cookies.mod.features.farming.garden.Plot;
import codes.cookies.mod.features.misc.timer.SbEntityToast;
import codes.cookies.mod.features.misc.timer.Timer;
import codes.cookies.mod.utils.cookies.CookiesUtils;
import codes.cookies.mod.utils.items.CookiesDataComponentTypes;
import codes.cookies.mod.utils.skyblock.LocationUtils;
import codes.cookies.mod.utils.skyblock.MayorUtils;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class PestTimer
extends Timer {
    public static final SbEntityToast.ImageData DATA = new SbEntityToast.ImageData(20, 20, 5, 7, class_2960.method_60655((String)"cookies-mod", (String)"textures/mobs/beetle.png"));
    long lastPestSpawnedTime = -1L;
    private String debug;

    public PestTimer() {
        super(FarmingCategory.pestTimer, "pest");
    }

    @Override
    boolean showNotification() {
        return LocationUtils.Island.GARDEN.isActive();
    }

    @Override
    public Optional<String> getDebug() {
        if (!this.isDebug()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.debug);
    }

    @Override
    void onChatMessage(String message) {
        if (!LocationUtils.Island.GARDEN.isActive()) {
            return;
        }
        if (message.startsWith("GROSS! A Pest has appeared in ") || message.startsWith("EWW! 2 Pests have spawned in") || message.startsWith("YUCK! ") && message.contains("Pests have spawned in")) {
            this.lastPestSpawnedTime = System.currentTimeMillis();
            this.hasBeenAlerted = false;
        }
    }

    int getBaseTime() {
        class_2561 footer = class_310.method_1551().field_1705.method_1750().field_2154;
        if (footer == null) {
            return 300;
        }
        String literalFooter = footer.getString();
        if (literalFooter.contains("Pest Repellent II")) {
            return 1200;
        }
        if (literalFooter.contains("Pest Repellent I")) {
            return 600;
        }
        return 300;
    }

    int getTimeBetweenPests() {
        double sprayedPlotReduction;
        StringBuilder stringBuilder = this.isDebug() ? new StringBuilder() : null;
        double baseTime = this.getBaseTime();
        List itemStacks = ProfileStorage.getCurrentProfile().map(ProfileData::getEquipmentData).map(EquipmentData::getValue).orElseGet(Collections::emptyList);
        if (stringBuilder != null) {
            stringBuilder.append("\u00a7m          \u00a7r\n");
        }
        for (class_1799 itemStack : itemStacks) {
            boolean foundAny = false;
            if ("PEST_VEST".equalsIgnoreCase((String)itemStack.method_57824(CookiesDataComponentTypes.SKYBLOCK_ID))) {
                baseTime *= 0.8;
                if (stringBuilder != null) {
                    stringBuilder.append("Found pest vest! (20%)\n");
                }
                foundAny = true;
            } else if ("PESTHUNTERS_GLOVES".equalsIgnoreCase((String)itemStack.method_57824(CookiesDataComponentTypes.SKYBLOCK_ID))) {
                baseTime *= 0.99;
                if (stringBuilder != null) {
                    stringBuilder.append("Found pest hunter gloves! (1%)\n");
                }
                foundAny = true;
            }
            if ("squeaky".equalsIgnoreCase((String)itemStack.method_57824(CookiesDataComponentTypes.MODIFIER))) {
                baseTime *= 0.99;
                if (stringBuilder != null) {
                    stringBuilder.append("Found squeaky modifier! (1%)\n");
                }
                foundAny = true;
            }
            if (!foundAny || stringBuilder == null) continue;
            stringBuilder.append("\u00a7m          \u00a7r\n");
        }
        if (MayorUtils.isPerkActive("pest_eradicator")) {
            if (stringBuilder != null) {
                stringBuilder.append("Finnegan perk (50%)");
            }
            sprayedPlotReduction = 0.25;
        } else {
            sprayedPlotReduction = 0.5;
        }
        PestTimerObject.TimerTreatment value = FarmingCategory.pestTimer.timerType;
        switch (value) {
            case FIRST: {
                boolean apply = ProfileStorage.getCurrentProfile().map(ProfileData::getPlotData).map(PlotData::isAnySprayed).orElse(false);
                if (!apply) break;
                if (stringBuilder != null) {
                    stringBuilder.append("One plot sprayed (50%)\n");
                }
                baseTime *= sprayedPlotReduction;
                break;
            }
            case CURRENT: {
                boolean applyCooldown;
                int currentPlot = CookiesUtils.getPlayer().map(class_1297::method_19538).map(Plot.getCurrentPlot()::toPlotId).orElse(-1);
                if (currentPlot == -1 || !(applyCooldown = ProfileStorage.getCurrentProfile().map(ProfileData::getPlotData).map(plotData -> plotData.isPlotSprayed(currentPlot)).orElse(false).booleanValue())) break;
                if (stringBuilder != null) {
                    stringBuilder.append("Current plot sprayed (50%)\n");
                }
                baseTime *= sprayedPlotReduction;
            }
        }
        if (stringBuilder != null) {
            stringBuilder.append("\u00a7m          \u00a7r\n");
            this.debug = stringBuilder.toString();
        }
        return (int)baseTime;
    }

    @Override
    class_2561 getNotificationMessage() {
        if (this.getTime() < 0) {
            return class_2561.method_43470((String)"You can spawn pests!");
        }
        return class_2561.method_43470((String)("Pests can spawn in " + this.getTime() + "s!"));
    }

    @Override
    class_2561 getChatMessage() {
        if (this.getTime() < 0) {
            CookiesUtils.createPrefix(43520).method_27693("Pests can spawn!");
        }
        return CookiesUtils.createPrefix(43520).method_27693("Pests can spawn soon! ").method_10852((class_2561)class_2561.method_43470((String)"(10s)").method_27692(class_124.field_1063));
    }

    @Override
    public int getTime() {
        int timeDelta = (int)((System.currentTimeMillis() - this.lastPestSpawnedTime) / 1000L);
        return this.getTimeBetweenPests() - timeDelta;
    }

    @Override
    SbEntityToast.ImageData getData() {
        return DATA;
    }

    @Generated
    public long getLastPestSpawnedTime() {
        return this.lastPestSpawnedTime;
    }
}

