/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.misc.timer;

import codes.cookies.mod.config.categories.objects.TimerObjects;
import codes.cookies.mod.features.misc.timer.NotificationManager;
import codes.cookies.mod.features.misc.timer.SbEntityToast;
import codes.cookies.mod.utils.cookies.CookiesUtils;
import codes.cookies.mod.utils.dev.DevUtils;
import codes.cookies.mod.utils.minecraft.SoundUtils;
import java.util.Optional;
import lombok.Generated;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_368;

public abstract class Timer {
    private final TimerObjects timerFoldable;
    private final class_2960 debug;
    boolean hasBeenAlerted = true;

    public Timer(TimerObjects timerFoldable, String id) {
        this.timerFoldable = timerFoldable;
        this.debug = DevUtils.createIdentifier("timer/" + id);
    }

    boolean isDeactivated() {
        return !this.timerFoldable.enabled;
    }

    NotificationManager.NotificationType getNotificationType() {
        return this.timerFoldable.type;
    }

    boolean playSound() {
        return this.timerFoldable.enableSound;
    }

    boolean showNotification() {
        return true;
    }

    int getAlertTime() {
        return 10;
    }

    abstract void onChatMessage(String var1);

    boolean isDebug() {
        return DevUtils.isEnabled(this.debug);
    }

    Optional<String> getDebug() {
        if (!this.isDebug()) {
            return Optional.empty();
        }
        return Optional.of("Timer: " + this.getTime());
    }

    abstract class_2561 getNotificationMessage();

    abstract class_2561 getChatMessage();

    abstract int getTime();

    void alert() {
        this.hasBeenAlerted = true;
        if (!this.showNotification()) {
            return;
        }
        if (this.getNotificationType() == NotificationManager.NotificationType.NONE) {
            return;
        }
        if (this.playSound()) {
            SoundUtils.playSound(class_3417.field_17265, 1.0f, 2.0f);
        }
        switch (this.getNotificationType()) {
            case BOTH: {
                this.alertBoth();
                break;
            }
            case TOAST: {
                this.sendToast();
                break;
            }
            case CHAT: {
                this.sendChat();
            }
        }
    }

    private void sendChat() {
        CookiesUtils.sendMessage(this.getChatMessage());
    }

    private void sendToast() {
        class_310.method_1551().method_1566().method_1999((class_368)new SbEntityToast(this.getData(), this::getNotificationMessage, 3000));
    }

    private void alertBoth() {
        this.sendChat();
        this.sendToast();
    }

    abstract SbEntityToast.ImageData getData();

    @Generated
    public boolean isHasBeenAlerted() {
        return this.hasBeenAlerted;
    }
}

