/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.misc.utils;

import codes.cookies.mod.events.InventoryEvents;
import codes.cookies.mod.events.api.InventoryContentUpdateEvent;
import codes.cookies.mod.utils.dev.BackedReference;
import codes.cookies.mod.utils.items.CookiesDataComponentTypes;
import codes.cookies.mod.utils.items.ItemUtils;
import codes.cookies.mod.utils.skyblock.InventoryUtils;
import codes.cookies.mod.utils.skyblock.SelectSlotInventory;
import it.unimi.dsi.fastutil.booleans.BooleanBooleanMutablePair;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_465;
import net.minecraft.class_9331;

public abstract class InventoryModifier {
    private final class_1799 stack;
    private final BackedReference<Boolean> toggleEntry;
    private final BackedReference<Integer> slotEntry;
    private final BooleanBooleanMutablePair couldPlace = new BooleanBooleanMutablePair(false, false);

    public InventoryModifier(class_1799 stack, String screenName, BackedReference<Boolean> toggleEntry, BackedReference<Integer> slotEntry) {
        this.stack = stack;
        this.toggleEntry = toggleEntry;
        this.slotEntry = slotEntry;
        InventoryEvents.beforeInit(screenName, this::shouldInstrument, this::afterInit);
    }

    protected boolean shouldInstrument(class_465<?> handledScreen) {
        return this.toggleEntry.get();
    }

    private void afterInit(class_465<?> handledScreen) {
        InventoryContentUpdateEvent.register(handledScreen.method_17577(), this::updateContents);
    }

    private void updateContents(int slot, class_1799 item) {
        if (slot > 53 || item == null || item.method_7960()) {
            return;
        }
        this.onItem(slot, item);
        if (slot != this.slotEntry.get() && this.couldPlace.firstBoolean()) {
            return;
        }
        if (slot == this.slotEntry.get() || this.couldPlace.secondBoolean()) {
            if (InventoryUtils.isSkyblockUiElement(item)) {
                this.set(item);
            } else {
                this.couldPlace.second(true);
            }
        }
    }

    protected void onItem(int slot, class_1799 item) {
    }

    protected Consumer<Integer> getConsumer() {
        if (this.useSound()) {
            return InventoryUtils.wrapWithSound(this::click);
        }
        return this::click;
    }

    private void set(class_1799 item) {
        class_1799 forgeStack = this.stack.method_7972();
        forgeStack.method_57379(CookiesDataComponentTypes.ITEM_CLICK_CONSUMER, this.getConsumer());
        item.method_57379(CookiesDataComponentTypes.OVERRIDE_ITEM, (Object)forgeStack);
        this.couldPlace.first(true);
        this.couldPlace.second(false);
    }

    protected boolean shouldInstrument(int clicked) {
        return clicked == 1;
    }

    protected void click(int clicked) {
        if (clicked == 1) {
            new SelectSlotInventory(this.getItemPredicate().or(InventoryUtils.isSkyblockUiElement()), this::selectNewSlot);
        } else {
            this.clicked(clicked);
        }
    }

    protected void clicked(int clicked) {
        this.clicked();
    }

    private void selectNewSlot(class_1735 slot) {
        this.slotEntry.set(slot.method_34266());
        this.set(slot.method_7677());
    }

    protected void clicked() {
    }

    protected abstract class_9331<?> getModifiedComponentType();

    private Predicate<class_1799> getItemPredicate() {
        return this::getItemPredicate;
    }

    private boolean getItemPredicate(class_1799 itemStack) {
        return Objects.nonNull(ItemUtils.getData(itemStack, this.getModifiedComponentType()));
    }

    protected boolean useSound() {
        return true;
    }
}

