/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.misc.utils;

import codes.cookies.mod.data.profile.ProfileData;
import codes.cookies.mod.data.profile.ProfileStorage;
import codes.cookies.mod.data.profile.sub.EquipmentData;
import codes.cookies.mod.events.api.InventoryContentUpdateEvent;
import codes.cookies.mod.utils.SkyblockUtils;
import codes.cookies.mod.utils.cookies.CookiesUtils;
import codes.cookies.mod.utils.items.CookiesDataComponentTypes;
import java.util.List;
import java.util.Locale;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_476;
import net.minecraft.class_9290;
import net.minecraft.class_9334;

public interface StatsTracker {
    public static void init() {
        ScreenEvents.AFTER_INIT.register(StatsTracker::afterInitScreen);
    }

    public static void afterInitScreen(class_310 minecraftClient, class_437 screen, int scaledWidth, int scaledHeight) {
        if (!(screen instanceof class_476)) {
            return;
        }
        class_476 genericContainerScreen = (class_476)screen;
        if (!SkyblockUtils.isCurrentlyInSkyblock()) {
            return;
        }
        if (!genericContainerScreen.method_25440().getString().contains("Your Equipment and Stats")) {
            return;
        }
        InventoryContentUpdateEvent.registerSlot(genericContainerScreen.method_17577(), StatsTracker::track);
    }

    public static void track(class_1735 slot) {
        class_1799 stack = slot.method_7677();
        int index = slot.method_34266();
        if (slot.field_7871 instanceof class_1661) {
            return;
        }
        if (stack.method_7964().getString().endsWith("Stats")) {
            StatsTracker.handle(stack);
        }
        if (index == 0) {
            ProfileStorage.getCurrentProfile().map(ProfileData::getEquipmentData).ifPresent(EquipmentData::reset);
        }
        if (stack.method_57826(CookiesDataComponentTypes.SKYBLOCK_ID) && index < 40 && index > 9) {
            ProfileStorage.getCurrentProfile().map(ProfileData::getEquipmentData).ifPresent(equipmentData -> equipmentData.add(stack));
        }
    }

    public static void handle(class_1799 stack) {
        class_9290 loreComponent = (class_9290)stack.method_57824(class_9334.field_49632);
        if (loreComponent == null) {
            return;
        }
        List texts = loreComponent.comp_2401();
        List<String> list = texts.stream().map(class_2561::getString).map(CookiesUtils::stripColor).toList();
        for (String s : list) {
            if (!s.matches(" . [\\w ]+ [\\d,.]+%?")) continue;
            String name = s.replaceAll(" . ([\\w ]+) [\\d,.]+%?", "$1");
            String literalAmount = s.replaceAll(" . [\\w ]+ ([\\d,.]+)%?", "$1");
            String id = name.toLowerCase(Locale.ROOT).replaceAll("[^\\w ]", "").replace(" ", "_");
            double amount = Double.parseDouble(literalAmount.replaceAll(",", ""));
            ProfileStorage.getCurrentProfile().ifPresent(profile -> profile.getProfileStats().saveStat(id, amount));
        }
    }
}

