/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.misc.utils;

import codes.cookies.mod.config.categories.MiscCategory;
import codes.cookies.mod.data.profile.ProfileData;
import codes.cookies.mod.data.profile.ProfileStorage;
import codes.cookies.mod.data.profile.sub.StorageData;
import codes.cookies.mod.events.api.InventoryContentUpdateEvent;
import codes.cookies.mod.services.item.ItemHighlightService;
import codes.cookies.mod.utils.SkyblockUtils;
import codes.cookies.mod.utils.exceptions.ExceptionHandler;
import codes.cookies.mod.utils.items.CookiesDataComponentTypes;
import codes.cookies.mod.utils.items.ItemTooltipComponent;
import codes.cookies.mod.utils.items.types.MiscDataComponentTypes;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_476;

public class StoragePreview {
    public StoragePreview() {
        ScreenEvents.BEFORE_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (!(screen instanceof class_476)) {
                return;
            }
            class_476 genericContainerScreen = (class_476)screen;
            if (!SkyblockUtils.isCurrentlyInSkyblock()) {
                return;
            }
            if (!MiscCategory.enableStoragePreview) {
                return;
            }
            if (!genericContainerScreen.method_25440().getString().equals("Storage")) {
                return;
            }
            InventoryContentUpdateEvent.register(genericContainerScreen.method_17577(), ExceptionHandler.wrap(this::updateInventory));
        });
    }

    private void updateInventory(int index, class_1799 itemStack) {
        String name = itemStack.method_7964().getString();
        StorageData.StorageLocation location = StorageData.StorageLocation.BACKPACK;
        if (name.startsWith("Ender Chest Page")) {
            location = StorageData.StorageLocation.ENDER_CHEST;
        } else if (!name.startsWith("Backpack Slot")) {
            return;
        }
        int page = index - (location == StorageData.StorageLocation.ENDER_CHEST ? 9 : 27);
        Optional<ProfileData> currentProfile = ProfileStorage.getCurrentProfile();
        if (currentProfile.isEmpty()) {
            return;
        }
        List<StorageData.StorageItem> items = currentProfile.get().getStorageData().getItems(page, location);
        if (items == null || items.isEmpty()) {
            return;
        }
        HashMap<Integer, class_1799> map = new HashMap<Integer, class_1799>();
        for (StorageData.StorageItem item : items) {
            class_1799 copy = item.itemStack().method_7972();
            map.put(item.slot(), copy);
            if (!copy.method_57826(MiscDataComponentTypes.ITEM_SEARCH_SERVICE_MODIFIED) || item.itemStack().method_7909() == class_1802.field_8739) continue;
            itemStack.method_57379(CookiesDataComponentTypes.ITEM_BACKGROUND_COLOR, (Object)((Integer)copy.method_57824(CookiesDataComponentTypes.ITEM_BACKGROUND_COLOR)));
            itemStack.method_57379(MiscDataComponentTypes.ITEM_SEARCH_SERVICE_MODIFIED, (Object)0);
            ItemHighlightService.add(itemStack);
            ItemHighlightService.add(copy);
        }
        itemStack.method_57379(CookiesDataComponentTypes.LORE_ITEMS, (Object)new ItemTooltipComponent(map));
    }
}

