/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.misc.utils.crafthelper;

import codes.cookies.mod.data.profile.items.ItemSources;
import codes.cookies.mod.features.misc.utils.crafthelper.EvaluationContext;
import codes.cookies.mod.features.misc.utils.crafthelper.ItemTracker;
import codes.cookies.mod.features.misc.utils.crafthelper.ToolTipContext;
import codes.cookies.mod.features.misc.utils.crafthelper.tooltips.CraftHelperComponent;
import codes.cookies.mod.repository.recipes.calculations.RecipeCalculationResult;
import codes.cookies.mod.repository.recipes.calculations.RecipeResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public record CraftHelperContext(List<CraftHelperComponent> components, String prefix, ItemTracker itemTracker, RecipeResult<?> result, EvaluationContext evaluationContext, String path, ToolTipContext toolTipContext) {
    public CraftHelperContext(List<CraftHelperComponent> components, String prefix, ItemTracker itemTracker, RecipeResult<?> result, EvaluationContext evaluationContext, String path) {
        this(components, prefix, itemTracker, result, evaluationContext, path, new ToolTipContext(result.getRepositoryItemNotNull(), prefix));
    }

    public static CraftHelperContext create(RecipeCalculationResult result, ItemSources ... values) {
        Stack<Integer> objects = new Stack<Integer>();
        objects.push(0);
        return new CraftHelperContext(new ArrayList<CraftHelperComponent>(), "  ", new ItemTracker(values), result, new EvaluationContext(null, result, objects), "root");
    }

    public ToolTipContext toContext() {
        if (!this.toolTipContext.hasBeenInitialized) {
            this.toolTipContext.amount = this.amount() - this.getAmountThroughParents();
            this.toolTipContext.amountThroughParents = this.getAmountThroughParents();
            this.toolTipContext.itemTracker = this.itemTracker.copy();
            this.toolTipContext.required = this.getMax() - this.getAmountThroughParents();
            this.toolTipContext.hasBeenInitialized = true;
            this.toolTipContext.path = this.path;
        }
        return this.toolTipContext;
    }

    public int getMax() {
        return this.result.getAmount();
    }

    public int getAmountThroughParents() {
        if (this.evaluationContext.parent() == null) {
            return 0;
        }
        int amount = this.evaluationContext.stack().peek() * (this.evaluationContext.recipeResult().getAmount() / this.evaluationContext.parent().recipeResult().getAmount());
        return Math.min(amount, this.result.getAmount());
    }

    public int amount() {
        int amount = 0;
        if (this.evaluationContext.parent() != null) {
            amount = this.getAmountThroughParents();
        }
        amount += this.itemTracker.take(this.result.getRepositoryItemNotNull(), this.getMax() - amount);
        return Math.min(amount, this.getMax());
    }

    public void pushAmount() {
        this.evaluationContext.stack().push(this.toolTipContext.getAmount() + this.toolTipContext.getAmountThroughParents());
    }

    public void popAmount() {
        this.evaluationContext.stack().pop();
    }

    public CraftHelperContext push(RecipeResult<?> recipeResult, boolean isLast) {
        Object newPrefix = this.prefix.isEmpty() ? (isLast ? "\u2514 " : "\u251c ") : this.prefix.replace("\u251c", "\u2502").replace("\u2514", "  ") + (isLast ? "\u2514 " : "\u251c ");
        return new CraftHelperContext(new ArrayList<CraftHelperComponent>(), (String)newPrefix, this.itemTracker, recipeResult, this.evaluationContext.push(recipeResult), this.path + "." + recipeResult.getId());
    }
}

