/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.misc.utils.crafthelper;

import codes.cookies.mod.config.categories.CraftHelperCategory;
import codes.cookies.mod.data.profile.items.ItemSources;
import codes.cookies.mod.features.misc.utils.crafthelper.CraftHelperContext;
import codes.cookies.mod.features.misc.utils.crafthelper.CraftHelperInstance;
import codes.cookies.mod.features.misc.utils.crafthelper.ToolTipContext;
import codes.cookies.mod.features.misc.utils.crafthelper.tooltips.CraftHelperComponent;
import codes.cookies.mod.features.misc.utils.crafthelper.tooltips.DebugComponent;
import codes.cookies.mod.features.misc.utils.crafthelper.tooltips.NormalComponent;
import codes.cookies.mod.repository.recipes.calculations.RecipeCalculationResult;
import codes.cookies.mod.repository.recipes.calculations.RecipeResult;
import java.util.List;

public class CraftHelperFormatter {
    public CraftHelperInstance instance;

    public CraftHelperFormatter(CraftHelperInstance instance) {
        this.instance = instance;
    }

    public List<CraftHelperComponent> format(RecipeCalculationResult result, CraftHelperInstance instance) {
        CraftHelperContext craftHelperContext = CraftHelperContext.create(result, (ItemSources[])CraftHelperCategory.getSources().toArray(ItemSources[]::new));
        this.append(craftHelperContext, instance);
        craftHelperContext.components().forEach(CraftHelperComponent::init);
        return craftHelperContext.components();
    }

    private void append(CraftHelperContext context, CraftHelperInstance instance) {
        ToolTipContext toolTipContext = context.toContext();
        toolTipContext.instance = instance;
        NormalComponent normalComponent = new NormalComponent(toolTipContext);
        normalComponent.setCollapsed(instance.getCollapsed().contains(toolTipContext.path));
        context.components().add(normalComponent);
        RecipeResult<?> recipeResult = context.result();
        if (recipeResult instanceof RecipeCalculationResult) {
            RecipeCalculationResult calculationResult = (RecipeCalculationResult)recipeResult;
            if (toolTipContext.isDone()) {
                context.components().add(new DebugComponent("Skipping children, parent full!"));
                return;
            }
            for (RecipeResult recipeResult2 : calculationResult.getRequired()) {
                toolTipContext.hasChildren = true;
                this.preAppend(context, recipeResult2, calculationResult.getRequired().indexOf(recipeResult2) == calculationResult.getRequired().size() - 1, normalComponent, instance);
            }
        } else {
            toolTipContext.childrenDone = false;
        }
    }

    private void preAppend(CraftHelperContext context, RecipeResult<?> recipeResult, boolean isLast, CraftHelperComponent current, CraftHelperInstance instance) {
        context.pushAmount();
        CraftHelperContext push = context.push(recipeResult, isLast);
        this.append(push, instance);
        ToolTipContext child = push.toContext();
        child.isLast = isLast;
        context.toContext().childrenDone = context.toContext().childrenDone && (push.toContext().isDone() || push.toContext().childrenDone);
        context.components().add(new DebugComponent(context.prefix() + "c: %s, d: %s, r: %s".formatted(context.toContext().childrenDone, push.toContext().isDone(), current.hashCode())));
        context.components().addAll(push.components());
        for (CraftHelperComponent component : push.components()) {
            if (!component.getParent().isEmpty()) continue;
            component.setParent(current);
        }
        context.popAmount();
    }
}

