/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.misc.utils.crafthelper;

import codes.cookies.mod.features.misc.utils.crafthelper.CraftHelperFormatter;
import codes.cookies.mod.features.misc.utils.crafthelper.CraftHelperManager;
import codes.cookies.mod.features.misc.utils.crafthelper.CraftHelperTooltipPositioner;
import codes.cookies.mod.features.misc.utils.crafthelper.tooltips.CraftHelperComponent;
import codes.cookies.mod.features.misc.utils.crafthelper.tooltips.CraftHelperComponentPart;
import codes.cookies.mod.features.misc.utils.crafthelper.tooltips.CraftHelperText;
import codes.cookies.mod.features.misc.utils.crafthelper.tooltips.HeadingPart;
import codes.cookies.mod.features.misc.utils.crafthelper.tooltips.SpacerComponent;
import codes.cookies.mod.features.misc.utils.crafthelper.tooltips.TooltipFieldPart;
import codes.cookies.mod.repository.RepositoryItem;
import codes.cookies.mod.repository.recipes.calculations.RecipeCalculationResult;
import codes.cookies.mod.repository.recipes.calculations.RecipeCalculator;
import codes.cookies.mod.screen.CookiesScreen;
import codes.cookies.mod.utils.Result;
import codes.cookies.mod.utils.accessors.ClickEventAccessor;
import codes.cookies.mod.utils.accessors.HoverEventAccessor;
import codes.cookies.mod.utils.cookies.CookiesUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3545;
import net.minecraft.class_5348;
import net.minecraft.class_5699;
import net.minecraft.class_8000;
import net.minecraft.class_8001;

public class CraftHelperInstance {
    public static final Codec<CraftHelperInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RepositoryItem.ID_CODEC.fieldOf("id").forGetter(CraftHelperInstance::getRepositoryItem), (App)class_5699.field_33441.fieldOf("amount").forGetter(CraftHelperInstance::getAmount), (App)Codec.STRING.listOf().fieldOf("collapsed").forGetter(CraftHelperInstance::getCollapsed)).apply((Applicative)instance, CraftHelperInstance::new));
    public static final CraftHelperInstance EMPTY = new CraftHelperInstance(RepositoryItem.EMPTY, 0, new ArrayList<String>());
    final RepositoryItem repositoryItem;
    final List<String> collapsed;
    private final CraftHelperFormatter formatter;
    int amount;
    HeadingPart headingPart;
    List<CraftHelperComponent> componentList = new ArrayList<CraftHelperComponent>();
    int width = 0;
    int height;
    int lastX;
    int lastY;
    int maxScroll = 0;
    boolean hasCalculated = false;
    int scroll = 0;

    public CraftHelperInstance(RepositoryItem repositoryItem, int amount, List<String> collapsed) {
        this.repositoryItem = repositoryItem;
        this.amount = amount;
        this.collapsed = new ArrayList<String>(collapsed);
        this.formatter = new CraftHelperFormatter(this);
    }

    public void recalculate() {
        this.componentList.clear();
        Result<RecipeCalculationResult, String> calculate = RecipeCalculator.calculate(this.repositoryItem);
        calculate.ifSuccess(this::finishRecalculation).ifError(errorMessage -> {
            CookiesUtils.sendFailedMessage(Optional.ofNullable(errorMessage).orElse("An error occurred while evaluating the recipe tree."));
            CraftHelperManager.remove();
        });
    }

    private void finishRecalculation(RecipeCalculationResult recipeCalculationResult) {
        this.componentList.clear();
        this.headingPart = new HeadingPart(this.repositoryItem, this);
        this.componentList.addAll(this.formatter.format(recipeCalculationResult.multiply(this.getAmount()), this));
        ArrayList<CraftHelperComponent> list = new ArrayList<CraftHelperComponent>(this.componentList);
        list.addFirst(this.headingPart);
        this.width = list.stream().mapToInt(component -> component.method_32664(class_310.method_1551().field_1772)).max().orElse(0) + 10;
        this.height = list.stream().filter(Predicate.not(CraftHelperComponent::isHidden)).limit(31L).mapToInt(component -> component.method_32661(class_310.method_1551().field_1772)).sum();
        this.maxScroll = (int)Math.max(list.stream().filter(Predicate.not(CraftHelperComponent::isHidden)).count() - 30L, 0L);
        this.hasCalculated = true;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CraftHelperInstance) {
            CraftHelperInstance other = (CraftHelperInstance)obj;
            return this.repositoryItem.equals(other.repositoryItem) && this.amount == other.amount;
        }
        return false;
    }

    public int getOffset() {
        return 0;
    }

    public List<CraftHelperComponent> getVisibleComponentList() {
        this.maxScroll = (int)Math.max(this.componentList.stream().filter(Predicate.not(CraftHelperComponent::isHidden)).count() - 30L, 0L);
        List<CraftHelperComponent> list = this.componentList.stream().filter(Predicate.not(CraftHelperComponent::isHidden)).skip(Math.min(this.scroll, this.maxScroll)).limit(30L).collect(Collectors.toList());
        list.addFirst(this.getHeadingPart());
        return list;
    }

    public void render(class_332 drawContext, int x, int y, int mouseX, int mouseY, float tickDelta) {
        if (!this.hasCalculated) {
            return;
        }
        this.lastX = x;
        this.lastY = y - this.height / 2;
        List<CraftHelperComponent> list = this.getVisibleComponentList();
        ArrayList<CraftHelperComponent> craftHelperComponents = new ArrayList<CraftHelperComponent>(list);
        craftHelperComponents.addFirst((CraftHelperComponent)((Object)new SpacerComponent(0, this.width)));
        drawContext.method_51435(class_310.method_1551().field_1772, craftHelperComponents, this.lastX, this.lastY, (class_8000)CraftHelperTooltipPositioner.INSTANCE, null);
        Optional<class_3545<CraftHelperComponentPart, Integer>> textUnder = this.getTextUnder(mouseX, mouseY, list);
        if (textUnder.isPresent()) {
            drawContext.method_51448().method_46416(0.0f, 0.0f, 100.0f);
            this.renderOverlay((CraftHelperComponentPart)textUnder.get().method_15442(), (Integer)textUnder.get().method_15441(), mouseX + x, mouseY + y, drawContext);
        }
    }

    private void renderOverlay(CraftHelperComponentPart part, int textX, int x, int y, class_332 drawContext) {
        if (part instanceof TooltipFieldPart) {
            TooltipFieldPart tooltipFieldPart = (TooltipFieldPart)part;
            drawContext.method_51436(class_310.method_1551().field_1772, tooltipFieldPart.getHoverText().stream().map(class_2561::method_30937).toList(), class_8001.field_41687, x, y);
        } else if (part instanceof CraftHelperText) {
            CraftHelperText text = (CraftHelperText)part;
            class_2583 styleAt = class_310.method_1551().field_1772.method_27527().method_27489((class_5348)text.text(), textX);
            if (styleAt == null) {
                return;
            }
            if (styleAt.method_10969() == null) {
                return;
            }
            Optional<List<class_2561>> hoverText = HoverEventAccessor.getText(styleAt.method_10969());
            hoverText.ifPresent(texts -> drawContext.method_51436(class_310.method_1551().field_1772, texts.stream().map(class_2561::method_30937).toList(), class_8001.field_41687, x, y));
        }
    }

    public Optional<class_3545<CraftHelperComponentPart, Integer>> getTextUnder(double mouseX, double rawMouseY, List<CraftHelperComponent> components) {
        double mouseY = rawMouseY + (double)((float)this.height / 2.0f);
        int heightOffset = 0;
        for (CraftHelperComponent craftHelperComponent : components) {
            int height = craftHelperComponent.method_32661(class_310.method_1551().field_1772);
            if (CookiesScreen.isInBound((int)mouseX, (int)mouseY, 0, heightOffset, this.width, height)) {
                return this.clicked(mouseX, mouseY - (double)heightOffset, craftHelperComponent);
            }
            heightOffset += height;
        }
        return Optional.empty();
    }

    public boolean onMouseClicked(double mouseX, double mouseY, int button) {
        Optional<Runnable> runnable;
        if (!this.hasCalculated) {
            return false;
        }
        Optional<class_3545<CraftHelperComponentPart, Integer>> textUnder = this.getTextUnder(mouseX, mouseY, this.getVisibleComponentList());
        if (textUnder.isEmpty()) {
            return false;
        }
        CraftHelperComponentPart left = (CraftHelperComponentPart)textUnder.get().method_15442();
        if (!(left instanceof CraftHelperText)) {
            return false;
        }
        CraftHelperText clickedText = (CraftHelperText)left;
        int x = (Integer)textUnder.get().method_15441();
        class_2583 styleAt = class_310.method_1551().field_1772.method_27527().method_27489((class_5348)clickedText.text(), x);
        if (styleAt == null) {
            return false;
        }
        if (styleAt.method_10970() != null && (runnable = ClickEventAccessor.getRunnable(styleAt.method_10970())).isPresent()) {
            runnable.ifPresent(Runnable::run);
            return true;
        }
        return false;
    }

    private Optional<class_3545<CraftHelperComponentPart, Integer>> clicked(double mouseX, double mouseY, CraftHelperComponent craftHelperComponent) {
        for (CraftHelperComponentPart textPart : craftHelperComponent.getTextParts()) {
            if (!CookiesScreen.isInBound((int)mouseX, (int)mouseY, textPart.x(), textPart.y(), textPart.width(), textPart.height())) continue;
            return Optional.of(new class_3545((Object)textPart, (Object)((int)mouseX - textPart.x())));
        }
        return Optional.empty();
    }

    public boolean onMouseScroll(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (!this.hasCalculated) {
            return false;
        }
        if (CookiesScreen.isInBound((int)mouseX, (int)mouseY + this.height / 2, 0, 0, this.width, this.height)) {
            this.scroll = Math.clamp((long)(this.scroll - (int)verticalAmount), 0, this.maxScroll);
            return true;
        }
        return false;
    }

    public boolean onKeyPressed(int key, int scancode, int modifiers) {
        return false;
    }

    public boolean onCharTyped(char chr, int modifiers) {
        return false;
    }

    public boolean onKeyReleased(int key, int scancode, int modifiers) {
        return false;
    }

    public void setCollapsed(String path) {
        this.collapsed.add(path);
    }

    @Generated
    public RepositoryItem getRepositoryItem() {
        return this.repositoryItem;
    }

    @Generated
    public List<String> getCollapsed() {
        return this.collapsed;
    }

    @Generated
    public CraftHelperFormatter getFormatter() {
        return this.formatter;
    }

    @Generated
    public int getAmount() {
        return this.amount;
    }

    @Generated
    public HeadingPart getHeadingPart() {
        return this.headingPart;
    }

    @Generated
    public List<CraftHelperComponent> getComponentList() {
        return this.componentList;
    }

    @Generated
    public int getWidth() {
        return this.width;
    }

    @Generated
    public int getHeight() {
        return this.height;
    }

    @Generated
    public int getLastX() {
        return this.lastX;
    }

    @Generated
    public int getLastY() {
        return this.lastY;
    }

    @Generated
    public int getMaxScroll() {
        return this.maxScroll;
    }

    @Generated
    public boolean isHasCalculated() {
        return this.hasCalculated;
    }

    @Generated
    public int getScroll() {
        return this.scroll;
    }

    @Generated
    public void setAmount(int amount) {
        this.amount = amount;
    }

    @Generated
    public void setHeadingPart(HeadingPart headingPart) {
        this.headingPart = headingPart;
    }

    @Generated
    public void setComponentList(List<CraftHelperComponent> componentList) {
        this.componentList = componentList;
    }

    @Generated
    public void setWidth(int width) {
        this.width = width;
    }

    @Generated
    public void setHeight(int height) {
        this.height = height;
    }

    @Generated
    public void setLastX(int lastX) {
        this.lastX = lastX;
    }

    @Generated
    public void setLastY(int lastY) {
        this.lastY = lastY;
    }

    @Generated
    public void setMaxScroll(int maxScroll) {
        this.maxScroll = maxScroll;
    }

    @Generated
    public void setHasCalculated(boolean hasCalculated) {
        this.hasCalculated = hasCalculated;
    }

    @Generated
    public void setScroll(int scroll) {
        this.scroll = scroll;
    }
}

