/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.misc.utils.crafthelper;

import codes.cookies.mod.config.categories.CraftHelperCategory;
import codes.cookies.mod.events.api.ScreenKeyEvents;
import codes.cookies.mod.features.misc.utils.crafthelper.CraftHelperInstance;
import codes.cookies.mod.features.misc.utils.crafthelper.CraftHelperLocation;
import codes.cookies.mod.features.misc.utils.crafthelper.CraftHelperTooltipPositioner;
import codes.cookies.mod.repository.RepositoryItem;
import codes.cookies.mod.utils.SkyblockUtils;
import codes.cookies.mod.utils.accessors.InventoryScreenAccessor;
import codes.cookies.mod.utils.compatibility.legendarytooltips.LegendaryTooltips;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Predicate;
import lombok.Generated;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenKeyboardEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenMouseEvents;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2ic;

public class CraftHelperManager {
    @NotNull
    private static CraftHelperInstance active = CraftHelperInstance.EMPTY;
    private static CraftHelperLocation location;

    public static void init() {
        location = (CraftHelperLocation)((Object)CraftHelperCategory.location.get());
        CraftHelperCategory.location.addListener((oldValue, newValue) -> {
            location = newValue;
        });
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (!(screen instanceof InventoryScreenAccessor)) {
                return;
            }
            if (!SkyblockUtils.isCurrentlyInSkyblock()) {
                return;
            }
            if (!CraftHelperCategory.enable) {
                return;
            }
            if (!active.equals(CraftHelperInstance.EMPTY)) {
                active.recalculate();
            }
            ScreenEvents.afterRender((class_437)screen).register(CraftHelperListener::onRender);
            ScreenMouseEvents.allowMouseClick((class_437)screen).register(CraftHelperListener::onMouseClick);
            ScreenMouseEvents.allowMouseScroll((class_437)screen).register(CraftHelperListener::onMouseScroll);
            ScreenKeyboardEvents.allowKeyPress((class_437)screen).register(CraftHelperListener::onKeyPressed);
            ScreenKeyboardEvents.allowKeyRelease((class_437)screen).register(CraftHelperListener::onKeyReleased);
            ScreenKeyEvents.getExtension(screen).cookies$allowCharTyped().register(CraftHelperListener::onCharTyped);
        });
    }

    public static void pushNewCraftHelperItem(RepositoryItem repositoryItem, int amount) {
        active = new CraftHelperInstance(repositoryItem, amount, new ArrayList<String>());
        active.recalculate();
    }

    public static void remove() {
        active = CraftHelperInstance.EMPTY;
    }

    @Generated
    public static void setActive(@NotNull CraftHelperInstance active) {
        if (active == null) {
            throw new NullPointerException("active is marked non-null but is null");
        }
        CraftHelperManager.active = active;
    }

    @NotNull
    @Generated
    public static CraftHelperInstance getActive() {
        return active;
    }

    private static interface CraftHelperListener {
        private static int calculateX(class_437 screen) {
            return switch (location) {
                default -> throw new MatchException(null, null);
                case CraftHelperLocation.LEFT -> 0;
                case CraftHelperLocation.LEFT_INVENTORY -> InventoryScreenAccessor.getX(screen) - 1;
                case CraftHelperLocation.RIGHT_INVENTORY -> InventoryScreenAccessor.getX(screen) + 1;
                case CraftHelperLocation.RIGHT -> screen.field_22789;
            };
        }

        private static int calculateY(class_437 screen, CraftHelperInstance craftHelperInstance) {
            return InventoryScreenAccessor.getY(screen) + InventoryScreenAccessor.getBackgroundHeight(screen) / 2 - craftHelperInstance.getOffset();
        }

        private static Vector2ic getPosition(class_437 screen, CraftHelperInstance craftHelperInstance) {
            int x = CraftHelperListener.calculateX(screen);
            int y = CraftHelperListener.calculateY(screen, craftHelperInstance);
            return CraftHelperTooltipPositioner.INSTANCE.method_47944(class_310.method_1551().method_22683().method_4486(), class_310.method_1551().method_22683().method_4502(), x, y, craftHelperInstance.width, craftHelperInstance.height);
        }

        private static Optional<CraftHelperInstance> getCurrent() {
            return Optional.of(active).filter(Predicate.not(CraftHelperInstance.EMPTY::equals));
        }

        public static void onRender(class_437 screen, class_332 drawContext, int mouseX, int mouseY, float tickDelta) {
            if (InventoryScreenAccessor.isDisabled(screen, InventoryScreenAccessor.Disabled.CRAFT_HELPER)) {
                return;
            }
            CraftHelperListener.getCurrent().ifPresent(instance -> {
                Vector2ic position = CraftHelperListener.getPosition(screen, instance);
                int x = position.x();
                int y = position.y();
                drawContext.method_51448().method_22903();
                drawContext.method_51448().method_46416(0.0f, 0.0f, -100.0f);
                LegendaryTooltips.getInstance().beforeTooltipRender(screen, drawContext);
                instance.render(drawContext, x, y, mouseX - x, mouseY - y, tickDelta);
                LegendaryTooltips.getInstance().afterTooltipRender(screen);
                drawContext.method_51448().method_22909();
            });
        }

        public static boolean onMouseClick(class_437 screen, double mouseX, double mouseY, int button) {
            return CraftHelperListener.getCurrent().map(instance -> {
                int y;
                Vector2ic position = CraftHelperListener.getPosition(screen, instance);
                int x = position.x();
                return !instance.onMouseClicked(mouseX - (double)x, mouseY - (double)(y = position.y()), button);
            }).orElse(true);
        }

        public static boolean onMouseScroll(class_437 screen, double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
            return CraftHelperListener.getCurrent().map(instance -> {
                int y;
                Vector2ic position = CraftHelperListener.getPosition(screen, instance);
                int x = position.x();
                return !instance.onMouseScroll(mouseX - (double)x, mouseY - (double)(y = position.y()), horizontalAmount, verticalAmount);
            }).orElse(true);
        }

        public static boolean onKeyPressed(class_437 screen, int key, int scancode, int modifiers) {
            return CraftHelperListener.getCurrent().map(instance -> !instance.onKeyPressed(key, scancode, modifiers)).orElse(true);
        }

        public static boolean onKeyReleased(class_437 screen, int key, int scancode, int modifiers) {
            return CraftHelperListener.getCurrent().map(instance -> !instance.onKeyReleased(key, scancode, modifiers)).orElse(true);
        }

        public static boolean onCharTyped(class_437 screen, char chr, int modifiers) {
            return CraftHelperListener.getCurrent().map(instance -> !instance.onCharTyped(chr, modifiers)).orElse(true);
        }
    }
}

