/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.misc.utils.crafthelper;

import codes.cookies.mod.data.profile.items.Item;
import codes.cookies.mod.data.profile.items.ItemSources;
import codes.cookies.mod.data.profile.items.sources.ForgeItemSource;
import codes.cookies.mod.repository.RepositoryItem;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.class_3545;
import org.jetbrains.annotations.NotNull;

public class ItemTracker {
    private final Map<RepositoryItem, TrackedItem> trackedItems = new HashMap<RepositoryItem, TrackedItem>();

    public ItemTracker(ItemSources ... sources) {
        Map<RepositoryItem, List<Item>> collect = ItemSources.getItems(sources).stream().collect(Collectors.groupingBy(RepositoryItem.getMappedOrEmpty(Item::itemStack)));
        collect.forEach((repositoryItem, items) -> this.trackedItems.put((RepositoryItem)repositoryItem, new TrackedItem((RepositoryItem)repositoryItem, (List<Item<?>>)items)));
    }

    public ItemTracker(ItemTracker itemTracker) {
        itemTracker.trackedItems.forEach((repositoryItem, trackedItem) -> this.trackedItems.put((RepositoryItem)repositoryItem, trackedItem.copy()));
    }

    public int getAmount(RepositoryItem repositoryItem) {
        if (this.trackedItems.containsKey(repositoryItem)) {
            return this.trackedItems.get((Object)repositoryItem).amount;
        }
        return 0;
    }

    public int take(RepositoryItem repositoryItem, int amount) {
        if (this.trackedItems.containsKey(repositoryItem)) {
            return this.trackedItems.get(repositoryItem).take(amount);
        }
        return 0;
    }

    public ItemTracker copy() {
        return new ItemTracker(this);
    }

    public TrackedItem get(RepositoryItem repositoryItem) {
        return this.trackedItems.getOrDefault(repositoryItem, TrackedItem.EMPTY);
    }

    public static class TrackedItem {
        public static TrackedItem EMPTY = new TrackedItem(RepositoryItem.EMPTY);
        @NotNull
        private final RepositoryItem repositoryItem;
        private final Map<ItemSources, List<Item<?>>> sources = new HashMap();
        private final Map<ItemSources, Integer> sourceAmounts = new HashMap<ItemSources, Integer>();
        private int amount = 0;
        private int consumed = 0;

        public TrackedItem(@NotNull RepositoryItem repositoryItem) {
            this.repositoryItem = repositoryItem;
        }

        public TrackedItem(@NotNull RepositoryItem repositoryItem, List<Item<?>> items) {
            this.repositoryItem = repositoryItem;
            for (Item<?> item : items) {
                if (item.source() == ItemSources.CRAFTABLE) continue;
                this.sources.computeIfAbsent(item.source(), s -> new ArrayList());
                this.sourceAmounts.computeIfPresent(item.source(), (itemSources, integer) -> integer + item.amount());
                this.sourceAmounts.computeIfAbsent(item.source(), s -> item.amount());
                this.sources.get((Object)item.source()).add(item);
                this.amount += item.amount();
            }
        }

        public TrackedItem(TrackedItem trackedItem) {
            this.repositoryItem = trackedItem.repositoryItem;
            this.amount = trackedItem.amount;
            this.consumed = trackedItem.consumed;
            this.sources.putAll(trackedItem.sources);
            this.sourceAmounts.putAll(trackedItem.sourceAmounts);
        }

        public int take(int max) {
            int remaining = this.amount - this.consumed;
            if (remaining > max) {
                this.consumed += max;
                return max;
            }
            this.consumed = this.amount;
            return remaining;
        }

        private int getAmountBefore(ItemSources source) {
            return this.sourceAmounts.keySet().stream().filter(current -> this.getPriority((ItemSources)((Object)current)) < this.getPriority(source)).map(this.sourceAmounts::get).filter(Objects::nonNull).mapToInt(Integer::intValue).sum();
        }

        public boolean hasUsed(ItemSources source) {
            if (!this.sourceAmounts.containsKey((Object)source) || this.sourceAmounts.getOrDefault((Object)source, 0) == 0) {
                return false;
            }
            int sum = this.getAmountBefore(source);
            return this.consumed > sum;
        }

        public List<ForgeItemSource.Context> getAllForgeStart() {
            if (!this.hasUsed(ItemSources.FORGE)) {
                return Collections.emptyList();
            }
            int amountBefore = this.getAmountBefore(ItemSources.FORGE);
            int forgeAmount = this.sourceAmounts.getOrDefault((Object)ItemSources.FORGE, 0);
            int index = Math.min(this.consumed - amountBefore, forgeAmount - 1);
            List orDefault = this.sources.getOrDefault((Object)ItemSources.FORGE, Collections.emptyList());
            if (orDefault.size() - 1 < index) {
                return Collections.emptyList();
            }
            return orDefault.stream().limit(index + 1).map(Item::data).map(ForgeItemSource.Context.class::cast).sorted(Comparator.comparingInt(ForgeItemSource.Context::slot)).toList();
        }

        public OptionalLong getLastForgeStarted() {
            if (!this.hasUsed(ItemSources.FORGE)) {
                return OptionalLong.empty();
            }
            int amountBefore = this.getAmountBefore(ItemSources.FORGE);
            int forgeAmount = this.sourceAmounts.getOrDefault((Object)ItemSources.FORGE, 0);
            int index = Math.min(this.consumed - amountBefore, forgeAmount - 1);
            List orDefault = this.sources.getOrDefault((Object)ItemSources.FORGE, Collections.emptyList());
            if (orDefault.size() - 1 < index) {
                return OptionalLong.empty();
            }
            return OptionalLong.of(((ForgeItemSource.Context)((Item)orDefault.get(index)).data()).startTime());
        }

        public int getPriority(ItemSources source) {
            return switch (source) {
                case ItemSources.INVENTORY -> 0;
                case ItemSources.SACKS -> 1;
                case ItemSources.STORAGE -> 2;
                case ItemSources.SACK_OF_SACKS -> 3;
                case ItemSources.VAULT -> 4;
                case ItemSources.POTION_BAG -> 5;
                case ItemSources.ACCESSORY_BAG -> 6;
                case ItemSources.FORGE -> 7;
                case ItemSources.CHESTS -> 8;
                default -> -1;
            };
        }

        public TrackedItem copy() {
            return new TrackedItem(this);
        }

        public List<class_3545<ItemSources, Integer>> getUsedSources(int amount) {
            int preConsume = this.consumed - amount;
            int consumed = 0;
            int currentAmount = 0;
            ArrayList<class_3545<ItemSources, Integer>> sources = new ArrayList<class_3545<ItemSources, Integer>>();
            for (ObjectIntPair pair : this.sourceAmounts.keySet().stream().sorted(Comparator.comparingInt(this::getPriority)).map(source -> ObjectIntPair.of((Object)source, (int)this.sourceAmounts.getOrDefault(source, 0))).toList()) {
                if (currentAmount + pair.rightInt() > preConsume && consumed != amount) {
                    int available = pair.rightInt() - (currentAmount - consumed);
                    if (available <= amount - consumed) {
                        sources.add((class_3545<ItemSources, Integer>)new class_3545((Object)((ItemSources)((Object)pair.left())), (Object)available));
                        consumed += available;
                    } else {
                        sources.add((class_3545<ItemSources, Integer>)new class_3545((Object)((ItemSources)((Object)pair.left())), (Object)(amount - consumed)));
                        consumed = amount;
                    }
                }
                currentAmount += pair.rightInt();
            }
            return sources;
        }

        @Generated
        public int getAmount() {
            return this.amount;
        }

        @Generated
        public int getConsumed() {
            return this.consumed;
        }
    }
}

