/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.misc.utils.crafthelper.tooltips;

import codes.cookies.mod.CookiesMod;
import codes.cookies.mod.features.misc.utils.crafthelper.CraftHelperInstance;
import codes.cookies.mod.features.misc.utils.crafthelper.CraftHelperManager;
import codes.cookies.mod.features.misc.utils.crafthelper.CraftHelperPlacement;
import codes.cookies.mod.features.misc.utils.crafthelper.tooltips.CraftHelperComponent;
import codes.cookies.mod.features.misc.utils.crafthelper.tooltips.CraftHelperComponentPart;
import codes.cookies.mod.features.misc.utils.crafthelper.tooltips.CraftHelperText;
import codes.cookies.mod.features.misc.utils.crafthelper.tooltips.TooltipFieldPart;
import codes.cookies.mod.repository.RepositoryItem;
import codes.cookies.mod.utils.RenderUtils;
import codes.cookies.mod.utils.minecraft.SoundUtils;
import codes.cookies.mod.utils.minecraft.TextBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public final class HeadingPart
extends CraftHelperComponent {
    private static final class_2960 SLOT = class_2960.method_60655((String)"cookies-mod", (String)"textures/gui/slot.png");
    private final RepositoryItem repositoryItem;
    private final CraftHelperText formattedName;
    private final int nameWidth;
    private final class_1799 stack;
    private final CraftHelperInstance instance;
    private final CraftHelperText close;
    private final TooltipFieldPart tooltipField;
    private final CraftHelperText amountText;

    public HeadingPart(RepositoryItem repositoryItem, class_2561 formattedName, int nameWidth, class_1799 stack, CraftHelperInstance instance) {
        this.repositoryItem = repositoryItem;
        this.nameWidth = nameWidth;
        this.stack = stack;
        this.instance = instance;
        this.formattedName = CraftHelperText.of(this.createHeading());
        this.close = CraftHelperText.of((class_2561)class_2561.method_43473().method_10852(this.createMove()).method_27693(" ").method_10852(this.createClose()));
        this.amountText = CraftHelperText.of(this.createAmount());
        this.tooltipField = new TooltipFieldPart(5, 5, 18, 18);
        this.tooltipField.setHoverText(this.getLore());
    }

    public HeadingPart(RepositoryItem repositoryItem, CraftHelperInstance craftHelperInstance) {
        this(repositoryItem, repositoryItem.getFormattedName(), class_310.method_1551().field_1772.method_27525((class_5348)repositoryItem.getFormattedName()), repositoryItem.constructItemStack(), craftHelperInstance);
    }

    private void pressedClose() {
        SoundUtils.playSound(class_3417.field_14627);
        CraftHelperManager.remove();
    }

    public void method_32666(class_327 textRenderer, int x, int y, int width, int height, class_332 context) {
        RenderUtils.renderBackgroundBox(context, x, y, 26, 26, -1);
        context.method_25290(class_1921::method_62277, SLOT, x + 4, y + 4, 0.0f, 0.0f, 18, 18, 18, 18);
        context.method_51448().method_22903();
        context.method_51448().method_46416(0.0f, 0.0f, -100.0f);
        context.method_51428(this.stack, x + 5, y + 5, (int)System.currentTimeMillis());
        context.method_51431(textRenderer, this.stack, x + 1, y + 1);
        context.method_51448().method_22909();
        int remainingWidth = width - 34;
        int nameDelta = remainingWidth - this.nameWidth;
        this.formattedName.setX(26 + nameDelta / 2);
        this.formattedName.setY(2);
        context.method_27535(textRenderer, this.formattedName.text(), x + this.formattedName.x(), y + this.formattedName.y(), -1);
        int amountWidth = textRenderer.method_27525((class_5348)this.amountText.text());
        int amountDelta = remainingWidth - amountWidth;
        this.amountText.setX(26 + amountDelta / 2);
        this.amountText.setY(13);
        context.method_27535(textRenderer, this.amountText.text(), x + this.amountText.x(), y + this.amountText.y(), -1);
        this.close.setX(width - 4 - textRenderer.method_27525((class_5348)this.close.text()));
        this.close.setY(1);
        context.method_27535(textRenderer, this.close.text(), x + this.close.x(), y + this.close.y(), -65536);
    }

    public int method_32661(class_327 textRenderer) {
        return 30;
    }

    public int method_32664(class_327 textRenderer) {
        return 60 + textRenderer.method_27525((class_5348)this.formattedName.text()) + textRenderer.method_27525((class_5348)this.close.text());
    }

    public RepositoryItem repositoryItem() {
        return this.repositoryItem;
    }

    public class_2561 formattedName() {
        return this.formattedName.text();
    }

    public int nameWidth() {
        return this.nameWidth;
    }

    public class_1799 stack() {
        return this.stack;
    }

    public CraftHelperInstance instance() {
        return this.instance;
    }

    private List<class_2561> getLore() {
        ArrayList<class_2561> lore = new ArrayList<class_2561>(this.repositoryItem.getLore());
        lore.addFirst(this.repositoryItem.getFormattedName());
        return lore;
    }

    private class_2561 createHeading() {
        return new TextBuilder(this.repositoryItem.getFormattedName()).onHover(this.getLore()).build();
    }

    private class_2561 createMove() {
        return new TextBuilder("\u2725").setRunnable(this::move).onHover(List.of(class_2561.method_43470((String)"Click to move").method_27692(class_124.field_1075))).formatted(class_124.field_1075).build();
    }

    private void move() {
        SoundUtils.playSound(class_3417.field_14627);
        CookiesMod.openScreen(new CraftHelperPlacement());
    }

    private class_2561 createClose() {
        return new TextBuilder("\u274c").formatted(class_124.field_1061, class_124.field_1067).setRunnable(this::pressedClose).onHover(List.of(class_2561.method_43470((String)"Close").method_27692(class_124.field_1061))).build();
    }

    private class_2561 createAmount() {
        class_5250 add = new TextBuilder(" + ").formatted(class_124.field_1060).onHover(List.of(class_2561.method_43470((String)"Increases the target amount").method_27692(class_124.field_1080), class_2561.method_43473(), class_2561.method_43470((String)"Click to increase by 1.").method_27692(class_124.field_1054), class_2561.method_43470((String)"Shift-click to increase by 10.").method_27692(class_124.field_1054))).setRunnable(this::increase).build();
        class_5250 remove = new TextBuilder(" - ").formatted(class_124.field_1061).onHover(List.of(class_2561.method_43470((String)"Decreases the target amount").method_27692(class_124.field_1080), class_2561.method_43473(), class_2561.method_43470((String)"Click to decrease by 1.").method_27692(class_124.field_1054), class_2561.method_43470((String)"Shift-click to decrease by 10.").method_27692(class_124.field_1054))).setRunnable(this::decrease).build();
        return class_2561.method_43473().method_10852((class_2561)remove).method_27693(" ").method_10852((class_2561)class_2561.method_43470((String)String.valueOf(this.instance.getAmount())).method_27692(class_124.field_1073)).method_27693(" ").method_10852((class_2561)add);
    }

    private void decrease() {
        int newAmount = class_437.method_25442() ? Math.max(1, this.instance.getAmount() - 10) : Math.max(1, this.instance.getAmount() - 1);
        SoundUtils.playSound(class_3417.field_14627);
        this.instance.setAmount(newAmount);
        this.instance.recalculate();
    }

    private void increase() {
        int newAmount = class_437.method_25442() ? this.instance.getAmount() + 10 : this.instance.getAmount() + 1;
        SoundUtils.playSound(class_3417.field_14627);
        this.instance.setAmount(newAmount);
        this.instance.recalculate();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        HeadingPart that = (HeadingPart)obj;
        return Objects.equals(this.repositoryItem, that.repositoryItem) && Objects.equals(this.formattedName, that.formattedName) && this.nameWidth == that.nameWidth && Objects.equals(this.stack, that.stack) && Objects.equals(this.instance, that.instance);
    }

    public int hashCode() {
        return Objects.hash(this.repositoryItem, this.formattedName, this.nameWidth, this.stack, this.instance);
    }

    public String toString() {
        return "HeadingPart[repositoryItem=" + String.valueOf(this.repositoryItem) + ", formattedName=" + String.valueOf(this.formattedName) + ", nameWidth=" + this.nameWidth + ", stack=" + String.valueOf(this.stack) + ", instance=" + String.valueOf(this.instance) + "]";
    }

    @Override
    public List<CraftHelperComponentPart> getTextParts() {
        return List.of(this.formattedName, this.close, this.amountText, this.tooltipField);
    }
}

