/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.misc.utils.crafthelper.tooltips;

import codes.cookies.mod.CookiesMod;
import codes.cookies.mod.data.profile.items.ItemSources;
import codes.cookies.mod.data.profile.items.sources.ForgeItemSource;
import codes.cookies.mod.features.misc.utils.crafthelper.ItemTracker;
import codes.cookies.mod.features.misc.utils.crafthelper.ToolTipContext;
import codes.cookies.mod.features.misc.utils.crafthelper.tooltips.CraftHelperComponent;
import codes.cookies.mod.features.misc.utils.crafthelper.tooltips.CraftHelperComponentPart;
import codes.cookies.mod.features.misc.utils.crafthelper.tooltips.CraftHelperText;
import codes.cookies.mod.repository.RepositoryItem;
import codes.cookies.mod.repository.recipes.CraftRecipe;
import codes.cookies.mod.repository.recipes.ForgeRecipe;
import codes.cookies.mod.screen.inventory.ForgeRecipeScreen;
import codes.cookies.mod.utils.ColorUtils;
import codes.cookies.mod.utils.cookies.CookiesUtils;
import codes.cookies.mod.utils.dev.DevUtils;
import codes.cookies.mod.utils.maths.MathUtils;
import codes.cookies.mod.utils.minecraft.NonCacheMutableText;
import codes.cookies.mod.utils.minecraft.SupplierTextContent;
import codes.cookies.mod.utils.minecraft.TextBuilder;
import codes.cookies.mod.utils.skyblock.ForgeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3545;
import net.minecraft.class_437;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7417;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class NormalComponent
extends CraftHelperComponent {
    private final ToolTipContext toolTipContext;
    private CraftHelperText text;
    private CraftHelperText secondText;

    public NormalComponent(ToolTipContext toolTipContext) {
        this.toolTipContext = toolTipContext;
    }

    private static Supplier<String> getSupplier(Supplier<Long> forgeTime, long lastForgeStartedSeconds) {
        return () -> {
            long time = (Long)forgeTime.get();
            if (time == -1L) {
                return "unknown";
            }
            long delta = System.currentTimeMillis() / 1000L - lastForgeStartedSeconds;
            int remaining = (int)(time - delta);
            if (remaining <= 0) {
                return "Done";
            }
            return CookiesUtils.formattedMs((long)remaining * 1000L);
        };
    }

    @Override
    public void init() {
        this.secondText = CraftHelperText.of((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)this.toolTipContext.getPrefix().replace("\u251c", "\u2502").replace("\u2514", "")).method_27692(class_124.field_1080)));
        this.secondText.setY(2);
        this.updateText();
    }

    private int getColor() {
        double percentage = (double)this.toolTipContext.getAmount() / (double)this.toolTipContext.getRequired();
        return ColorUtils.calculateBetween(class_124.field_1061.method_532(), class_124.field_1060.method_532(), percentage);
    }

    private class_2561 getIcon() {
        if (this.toolTipContext.isDone()) {
            if (this.toolTipContext.getPrefix().isBlank()) {
                return class_2561.method_43470((String)"\u2691").method_27692(class_124.field_1060);
            }
            return class_2561.method_43470((String)"\u2714").method_27695(new class_124[]{class_124.field_1060, class_124.field_1067});
        }
        if (this.toolTipContext.isChildrenDone()) {
            if (this.toolTipContext.getPrefix().isBlank()) {
                return class_2561.method_43470((String)"\u2691").method_27692(class_124.field_1054);
            }
            return class_2561.method_43470((String)"\u26a0").method_27692(class_124.field_1054);
        }
        if (this.toolTipContext.getPrefix().isBlank()) {
            return class_2561.method_43470((String)"\u2690").method_27692(class_124.field_1061);
        }
        return class_2561.method_43470((String)"\u274c").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067});
    }

    private void updateText() {
        class_5250 text = this.createText();
        this.text = this.toolTipContext.nonCachedText ? CraftHelperText.of((class_2561)new NonCacheMutableText(text)) : CraftHelperText.of((class_2561)text);
    }

    private void collapse() {
        this.collapsed = !this.collapsed;
        this.updateText();
        if (this.collapsed) {
            this.toolTipContext.instance.setCollapsed(this.toolTipContext.getPath());
        } else {
            this.toolTipContext.instance.getCollapsed().remove(this.toolTipContext.getPath());
        }
        this.toolTipContext.instance.recalculate();
    }

    private List<class_2561> getHover() {
        ArrayList<class_2561> hover = new ArrayList<class_2561>();
        hover.add(this.toolTipContext.getRepositoryItem().getFormattedName());
        hover.add((class_2561)class_2561.method_43473());
        int amount = this.toolTipContext.getAmount();
        if (amount != 0) {
            ItemTracker.TrackedItem trackedItem = this.toolTipContext.getItemTracker().get(this.toolTipContext.getRepositoryItem());
            List<class_3545<ItemSources, Integer>> usedSources = trackedItem.getUsedSources(amount);
            hover.add((class_2561)class_2561.method_43470((String)"Item Sources").method_27692(class_124.field_1060));
            for (class_3545<ItemSources, Integer> usedSource : usedSources) {
                ItemSources sources = (ItemSources)((Object)usedSource.method_15442());
                this.toolTipContext.getUsedSources().add(sources);
                int usedAmount = (Integer)usedSource.method_15441();
                hover.add((class_2561)sources.getName().method_27661().method_27692(class_124.field_1080).method_27693(": ").method_10852((class_2561)class_2561.method_43470((String)MathUtils.NUMBER_FORMAT.format(usedAmount)).method_27692(class_124.field_1054)));
            }
            hover.add((class_2561)class_2561.method_43473());
            if (this.toolTipContext.getUsedSources().contains((Object)ItemSources.FORGE)) {
                List<ForgeItemSource.Context> allForgeStart = this.toolTipContext.getItemTracker().get(this.toolTipContext.getRepositoryItem()).getAllForgeStart();
                hover.add((class_2561)class_2561.method_43470((String)"Forge Slots").method_27692(class_124.field_1060));
                for (ForgeItemSource.Context context : allForgeStart) {
                    TextBuilder forgeTime = this.getForgeTime(OptionalLong.of(context.startTime()));
                    hover.add((class_2561)new NonCacheMutableText(class_2561.method_43470((String)"Slot #%s: ".formatted(context.slot() + 1)).method_27692(class_124.field_1080).method_10852((class_2561)forgeTime.build().method_27692(class_124.field_1063))));
                }
                hover.add((class_2561)class_2561.method_43473());
            }
        }
        if (DevUtils.isEnabled(DEBUG)) {
            hover.add((class_2561)class_2561.method_43470((String)("A: " + this.toolTipContext.getAmount())));
            hover.add((class_2561)class_2561.method_43470((String)("ATP: : " + this.toolTipContext.getAmountThroughParents())));
            hover.add((class_2561)class_2561.method_43470((String)("Req: " + this.toolTipContext.getRequired())));
            hover.add((class_2561)class_2561.method_43470((String)("Item: " + this.toolTipContext.getRepositoryItem().getInternalId())));
            hover.add((class_2561)class_2561.method_43473());
        }
        if (this.toolTipContext.isDone()) {
            hover.add((class_2561)class_2561.method_43470((String)"You finished this item!").method_27692(class_124.field_1060));
        } else {
            class_124 formatting;
            if (this.toolTipContext.isChildrenDone()) {
                formatting = class_124.field_1054;
                hover.add((class_2561)class_2561.method_43470((String)"You have all materials to craft this item!").method_27692(class_124.field_1054));
            } else {
                formatting = class_124.field_1061;
                hover.add((class_2561)class_2561.method_43470((String)"You are missing some materials to craft this item!").method_27692(class_124.field_1061));
            }
            if (!this.toolTipContext.getRepositoryItem().getRecipes().isEmpty()) {
                hover.add((class_2561)class_2561.method_43470((String)"Click to open recipe!").method_27692(formatting));
            }
        }
        return hover;
    }

    public class_2561 createIconWithStyle(List<class_2561> hover) {
        return new TextBuilder(this.getIcon()).onHover(hover).setRunnable(this::clickText).build();
    }

    public class_2561 createCountWithStyle(List<class_2561> hover) {
        return new TextBuilder((class_2561)class_2561.method_43470((String)" %s/%s ".formatted(MathUtils.NUMBER_FORMAT.format(this.toolTipContext.getAmount()), MathUtils.NUMBER_FORMAT.format(this.toolTipContext.getRequired()))).method_54663(this.getColor())).onHover(hover).setRunnable(this::clickText).build();
    }

    public class_2561 createNameWithStyle(List<class_2561> hover) {
        return new TextBuilder(this.toolTipContext.getRepositoryItem().getFormattedName()).onHover(hover).setRunnable(this::clickText).build();
    }

    private void clickText() {
        if (this.toolTipContext.isDone()) {
            return;
        }
        RepositoryItem repositoryItem = this.toolTipContext.getRepositoryItem();
        if (repositoryItem.getRecipes().stream().anyMatch(CraftRecipe.class::isInstance)) {
            CookiesUtils.sendCommand("viewrecipe " + this.toolTipContext.getRepositoryItem().getInternalId());
            Optional.ofNullable(class_310.method_1551().field_1755).ifPresent(class_437::method_25419);
        } else if (repositoryItem.getRecipes().stream().anyMatch(ForgeRecipe.class::isInstance)) {
            CookiesMod.openScreen(new ForgeRecipeScreen(repositoryItem.getRecipes().stream().filter(ForgeRecipe.class::isInstance).map(ForgeRecipe.class::cast).findFirst().orElseThrow(), null));
        }
    }

    public class_5250 createText() {
        List<class_2561> hover = this.getHover();
        return new TextBuilder((class_2561)class_2561.method_43470((String)this.toolTipContext.getPrefix()).method_27692(class_124.field_1080)).append(this.createIconWithStyle(hover)).append(this.createCountWithStyle(hover)).append(this.createNameWithStyle(hover)).append(this.createSpecialWithStyle(hover)).build();
    }

    private class_2561 createSpecialWithStyle(List<class_2561> hover) {
        TextBuilder textBuilder = new TextBuilder((class_2561)class_2561.method_43470((String)" ")).formatted(class_124.field_1063);
        if (this.toolTipContext.getUsedSources().contains((Object)ItemSources.CHESTS)) {
            textBuilder.append("\ud83e\uddf0 ");
        }
        if (this.toolTipContext.getUsedSources().contains((Object)ItemSources.FORGE)) {
            OptionalLong lastForgeStarted = this.toolTipContext.getItemTracker().get(this.toolTipContext.getRepositoryItem()).getLastForgeStarted();
            textBuilder.append("(");
            TextBuilder forgeTime = this.getForgeTime(lastForgeStarted);
            forgeTime.onHover(hover).setRunnable(this::clickText).formatted(class_124.field_1063);
            textBuilder.append((class_2561)forgeTime.build());
            textBuilder.append(") ");
            this.toolTipContext.nonCachedText = true;
        }
        if (this.toolTipContext.isHasChildren()) {
            String fold = this.collapsed ? "\u25c0 " : "\u25bc ";
            textBuilder.append((class_2561)new TextBuilder(fold).formatted(class_124.field_1080).setRunnable(this::collapse).onHover(List.of(class_2561.method_43470((String)"Click to collapse!").method_27692(class_124.field_1080))).build());
        }
        textBuilder.onHover(hover).setRunnable(this::clickText);
        if (this.toolTipContext.nonCachedText) {
            return new NonCacheMutableText(textBuilder.build());
        }
        return textBuilder.build();
    }

    @NotNull
    private TextBuilder getForgeTime(OptionalLong lastForgeStarted) {
        TextBuilder forgeTime;
        if (lastForgeStarted.isEmpty()) {
            forgeTime = new TextBuilder((class_2561)class_2561.method_43470((String)"Unknown"));
        } else {
            Supplier<String> supplier = NormalComponent.getSupplier(() -> ForgeUtils.getForgeTime(this.toolTipContext.getRepositoryItem()), lastForgeStarted.getAsLong());
            SupplierTextContent supplierTextContent = new SupplierTextContent(supplier);
            NonCacheMutableText nonCacheMutableText = new NonCacheMutableText(class_5250.method_43477((class_7417)supplierTextContent));
            forgeTime = new TextBuilder((class_2561)nonCacheMutableText);
        }
        return forgeTime;
    }

    @Override
    public List<CraftHelperComponentPart> getTextParts() {
        return List.of(this.text, this.secondText);
    }

    public void method_32665(class_327 textRenderer, int x, int y, Matrix4f matrix, class_4597.class_4598 vertexConsumers) {
        textRenderer.method_27522(this.text.text(), (float)x + (float)this.text.x(), (float)y + (float)this.text.y(), -1, true, matrix, (class_4597)vertexConsumers, class_327.class_6415.field_33993, 0, 0xF000F0);
        textRenderer.method_27522(this.secondText.text(), (float)x + (float)this.secondText.x(), (float)y + (float)this.secondText.y(), -1, true, matrix, (class_4597)vertexConsumers, class_327.class_6415.field_33993, 0, 0xF000F0);
    }

    public int method_32661(class_327 textRenderer) {
        return 10;
    }

    public int method_32664(class_327 textRenderer) {
        return textRenderer.method_27525((class_5348)this.text.text());
    }
}

