/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.features.search;

import codes.cookies.mod.CookiesMod;
import codes.cookies.mod.config.categories.ItemSearchCategory;
import codes.cookies.mod.config.categories.MiscCategory;
import codes.cookies.mod.data.profile.items.Item;
import codes.cookies.mod.data.profile.items.ItemCompound;
import codes.cookies.mod.data.profile.items.ItemSources;
import codes.cookies.mod.data.profile.items.sources.CraftableItemSource;
import codes.cookies.mod.events.InventoryEvents;
import codes.cookies.mod.events.api.InventoryContentUpdateEvent;
import codes.cookies.mod.repository.RepositoryItem;
import codes.cookies.mod.repository.constants.MuseumData;
import codes.cookies.mod.repository.constants.RepositoryConstants;
import codes.cookies.mod.screen.search.InspectItemScreen;
import codes.cookies.mod.services.item.ItemSearchService;
import codes.cookies.mod.services.item.ItemServices;
import codes.cookies.mod.utils.Either;
import codes.cookies.mod.utils.Result;
import codes.cookies.mod.utils.exceptions.ExceptionHandler;
import codes.cookies.mod.utils.items.CookiesDataComponentTypes;
import codes.cookies.mod.utils.items.ItemTooltipComponent;
import codes.cookies.mod.utils.items.ItemUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_9282;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import org.apache.commons.lang3.StringUtils;

public class MuseumHelper {
    Map<RepositoryItem, List<Item<?>>> items;

    public static void init() {
        InventoryEvents.beforeInit("cookies-regex:.*?[Mm]useum.*?", MuseumHelper::isEnabled, MuseumHelper::new);
    }

    private static boolean isEnabled(class_465<?> handledScreen) {
        return MuseumHelper.showItemSearch() || MuseumHelper.showArmorSets();
    }

    public MuseumHelper(class_465<?> handledScreen) {
        InventoryContentUpdateEvent.register(handledScreen.method_17577(), ExceptionHandler.wrap(this::update));
        this.items = ItemSources.getItems().stream().collect(Collectors.groupingBy(item -> Objects.requireNonNullElse((RepositoryItem)item.itemStack().method_57824(CookiesDataComponentTypes.REPOSITORY_ITEM), RepositoryItem.EMPTY)));
    }

    private static boolean showItemSearch() {
        return ItemSearchCategory.showInMuseum;
    }

    private static boolean showArmorSets() {
        return MiscCategory.showMuseumArmorSets;
    }

    private void update(int slot, class_1799 itemStack) {
        if (slot > 53) {
            return;
        }
        Result<Either<MuseumData.MuseumItem, MuseumData.ArmorItem>, MuseumData.MuseumDataError> itemByName = RepositoryConstants.museumData.getItemByName(itemStack.method_7964().getString());
        if (itemByName.isError()) {
            if (this.isDonatedOrUiItem(itemStack)) {
                return;
            }
            itemByName.getError().ifPresent(error -> {
                class_1799 item;
                switch (error.errorType()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case NO_ARMOR_FOUND: {
                        class_1799 stack = new class_1799((class_1935)class_1802.field_8264);
                        stack.method_57379(class_9334.field_49644, (Object)new class_9282(-25701, false));
                        class_1799 class_17992 = stack;
                        break;
                    }
                    case ITEM_NOT_FOUND: {
                        class_1799 class_17992 = itemStack;
                        break;
                    }
                    case NO_MATCHING_MUSEUM_FOUND: {
                        class_1799 class_17992 = item = class_1802.field_8077.method_7854();
                    }
                }
                if (itemStack == item) {
                    return;
                }
                ItemUtils.copy(class_9334.field_49631, itemStack, item);
                ItemUtils.copy(class_9334.field_50239, itemStack, item);
                class_9290 loreComponent = (class_9290)itemStack.method_57824(class_9334.field_49632);
                if (loreComponent == null) {
                    itemStack.method_57379(CookiesDataComponentTypes.CUSTOM_LORE, List.of(class_2561.method_43470((String)("Can't find item by name " + itemStack.method_7964().getString())).method_27692(class_124.field_1061)));
                } else {
                    ArrayList<class_5250> lines = new ArrayList<class_5250>(loreComponent.comp_2400());
                    lines.add(class_2561.method_43473());
                    lines.add(class_2561.method_43470((String)("Can't find item by name " + itemStack.method_7964().getString())).method_27692(class_124.field_1061));
                    itemStack.method_57379(CookiesDataComponentTypes.CUSTOM_LORE, lines);
                }
                itemStack.method_57379(CookiesDataComponentTypes.OVERRIDE_ITEM, (Object)item);
            });
            return;
        }
        Optional<Either<MuseumData.MuseumItem, MuseumData.ArmorItem>> optionalResult = itemByName.getResult();
        if (optionalResult.isEmpty()) {
            return;
        }
        Either<MuseumData.MuseumItem, MuseumData.ArmorItem> result = optionalResult.get();
        if (result.isLeft()) {
            if (!MuseumHelper.showItemSearch()) {
                return;
            }
            result.getLeft().ifPresent(item -> this.handleMuseumItem((MuseumData.MuseumItem)item, itemStack));
        } else {
            result.getRight().ifPresent(armor -> this.handleMuseumArmor((MuseumData.ArmorItem)armor, itemStack));
        }
    }

    public boolean isDonatedOrUiItem(class_1799 stack) {
        return stack.method_7909() != class_1802.field_8298;
    }

    private void handleMuseumItem(MuseumData.MuseumItem item, class_1799 itemStack) {
        if (this.isDonatedOrUiItem(itemStack)) {
            return;
        }
        Item source = this.items.getOrDefault(item.item(), Collections.emptyList()).stream().min(Comparator.comparingInt(element -> this.mapToPriority(element.source()))).orElse(null);
        if (source == null) {
            return;
        }
        List texts = Objects.requireNonNullElse((List)itemStack.method_57824(CookiesDataComponentTypes.CUSTOM_LORE), new ArrayList(((class_9290)itemStack.method_57824(class_9334.field_49632)).comp_2401()));
        if (source.source() == ItemSources.CRAFTABLE) {
            Object t = source.data();
            if (t instanceof CraftableItemSource.Data) {
                CraftableItemSource.Data data = (CraftableItemSource.Data)t;
                class_5250 text = class_2561.method_43470((String)"This item can be crafted!");
                texts.add(class_2561.method_43473());
                if (data.hasAllIngredients() && data.canSupercraft()) {
                    itemStack.method_57379(CookiesDataComponentTypes.OVERRIDE_RENDER_ITEM, (Object)class_1802.field_8408.method_7854());
                } else if (data.hasAllIngredients() && data.showSupercraftWarning()) {
                    text.method_27692(class_124.field_1054);
                    texts.add(text);
                    itemStack.method_57379(CookiesDataComponentTypes.OVERRIDE_RENDER_ITEM, (Object)class_1802.field_8192.method_7854());
                } else {
                    text.method_27692(class_124.field_1061);
                    texts.add(text);
                    itemStack.method_57379(CookiesDataComponentTypes.OVERRIDE_RENDER_ITEM, (Object)class_1802.field_8492.method_7854());
                }
                ItemServices.addCraftableTooltip(texts, data);
                if (data.showSupercraftWarning()) {
                    texts.add(class_2561.method_43471((String)"cookies.screen.item_search.overview").method_27692(class_124.field_1054));
                }
            }
            itemStack.method_57379(CookiesDataComponentTypes.ITEM_CLICK_CONSUMER, this.performAction(source));
            itemStack.method_57379(CookiesDataComponentTypes.CUSTOM_LORE, (Object)texts);
            return;
        }
        texts.add(class_2561.method_43473());
        texts.add(class_2561.method_43470((String)"This item was found somewhere on your profile!").method_27692(class_124.field_1060));
        ItemServices.appendMultiTooltip(ItemCompound.CompoundType.of(source.source(), source.data()), source.data(), texts);
        itemStack.method_57379(CookiesDataComponentTypes.ITEM_CLICK_CONSUMER, this.performAction(source));
        itemStack.method_57379(CookiesDataComponentTypes.CUSTOM_LORE, (Object)texts);
        itemStack.method_57379(CookiesDataComponentTypes.OVERRIDE_RENDER_ITEM, (Object)class_1802.field_8408.method_7854());
    }

    private void handleMuseumArmor(MuseumData.ArmorItem armor, class_1799 itemStack) {
        List<RepositoryItem> rawItems = armor.armorIds().stream().sorted(Comparator.comparingInt(this::mapToPriority)).toList();
        class_9290 loreComponent = (class_9290)itemStack.method_57824(class_9334.field_49632);
        if (loreComponent == null) {
            return;
        }
        List<class_5250> texts = Objects.requireNonNullElse((List)itemStack.method_57824(CookiesDataComponentTypes.CUSTOM_LORE), new ArrayList(((class_9290)itemStack.method_57824(class_9334.field_49632)).comp_2401()));
        List list = texts.stream().takeWhile(text -> text.method_10855().stream().map(class_2561::method_10866).noneMatch(class_2583::method_10986)).collect(Collectors.toList());
        texts.removeAll(list);
        if (MuseumHelper.showArmorSets()) {
            List<class_1799> collect = rawItems.stream().map(RepositoryItem::constructItemStack).collect(Collectors.toList());
            list.add(class_2561.method_43473());
            itemStack.method_57379(CookiesDataComponentTypes.LORE_ITEMS, (Object)new ItemTooltipComponent(collect, 4, new ArrayList<class_2561>(list)));
            list.clear();
        }
        if (MuseumHelper.showItemSearch() && !this.isDonatedOrUiItem(itemStack)) {
            List<RepositoryItem> sources = rawItems.stream().map(item -> this.items.getOrDefault(item, Collections.emptyList())).map(itemList -> itemList.stream().min(Comparator.comparingInt(element -> this.mapToPriority(element.source())))).filter(Optional::isPresent).map(Optional::get).filter(item -> item.source() != ItemSources.CRAFTABLE).map(item -> (RepositoryItem)item.itemStack().method_57824(CookiesDataComponentTypes.REPOSITORY_ITEM)).filter(Objects::nonNull).toList();
            int maxLength = 0;
            class_5250 bars = class_2561.method_43473().method_27695(new class_124[]{class_124.field_1055, class_124.field_1080});
            list.add(bars);
            boolean allPresent = true;
            for (RepositoryItem rawItem : rawItems) {
                class_5250 line = class_2561.method_43473();
                boolean isAvailable = sources.contains(rawItem);
                boolean bl = allPresent = allPresent && isAvailable;
                if (isAvailable) {
                    line.method_10852((class_2561)class_2561.method_43470((String)"\u2714").method_27692(class_124.field_1060));
                } else {
                    line.method_10852((class_2561)class_2561.method_43470((String)"\u274c").method_27692(class_124.field_1061));
                }
                line.method_10852((class_2561)class_2561.method_43470((String)" "));
                line.method_10852(rawItem.getFormattedName());
                int width = class_310.method_1551().field_1772.method_27525((class_5348)line);
                if (width > maxLength) {
                    maxLength = width;
                }
                list.add(line);
            }
            if (allPresent) {
                itemStack.method_57379(CookiesDataComponentTypes.OVERRIDE_RENDER_ITEM, (Object)class_1802.field_8408.method_7854());
            }
            int width = class_310.method_1551().field_1772.method_1727(" ");
            bars.method_27693(StringUtils.repeat((char)' ', (int)(maxLength / width + 1)));
            list.add(bars);
            if (!texts.isEmpty()) {
                texts.removeFirst();
            }
        }
        texts.addAll(0, list);
        itemStack.method_57379(CookiesDataComponentTypes.CUSTOM_LORE, texts.isEmpty() ? Collections.singletonList(class_2561.method_43473()) : texts);
    }

    public int mapToPriority(ItemSources source) {
        return switch (source) {
            default -> throw new MatchException(null, null);
            case ItemSources.STORAGE, ItemSources.INVENTORY, ItemSources.VAULT -> 1;
            case ItemSources.CHESTS -> 2;
            case ItemSources.ACCESSORY_BAG, ItemSources.FORGE, ItemSources.POTION_BAG, ItemSources.SACKS, ItemSources.SACK_OF_SACKS -> 3;
            case ItemSources.CRAFTABLE -> 4;
        };
    }

    private Consumer<Integer> performAction(Item<?> item) {
        return button -> {
            ItemCompound.CompoundType compoundType = ItemCompound.CompoundType.of(item.source(), item.data());
            Object itemData = item.data();
            if (button == 0) {
                ItemSearchService.performAction(compoundType, itemData, item);
            } else if (button == 1) {
                CraftableItemSource.Data data;
                if (itemData instanceof CraftableItemSource.Data && !(data = (CraftableItemSource.Data)itemData).showSupercraftWarning()) {
                    return;
                }
                CookiesMod.openScreen(new InspectItemScreen(new ItemCompound(item), null));
            }
        };
    }

    private int mapToPriority(RepositoryItem repositoryItem) {
        return switch (Objects.requireNonNullElse(repositoryItem.getCategory(), "").replaceAll("DUNGEON", "").trim()) {
            case "HELMET" -> 1;
            case "CHESTPLATE" -> 2;
            case "LEGGINGS" -> 3;
            case "BOOTS" -> 4;
            case "NECKLACE" -> 5;
            case "CLOAK" -> 6;
            case "BELT" -> 7;
            case "BRACELET" -> 8;
            default -> Integer.MAX_VALUE;
        };
    }
}

