/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.render;

import codes.cookies.mod.render.Renderable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.Generated;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_243;

public class WorldRender {
    private static final List<Renderable> renderables = new CopyOnWriteArrayList<Renderable>();
    private static long renderTimeNs = -1L;
    private static long outlinesNs = -1L;
    private static boolean hasOutlines = false;

    public static synchronized void addRenderable(Renderable renderable) {
        renderables.add(renderable);
        renderable.load();
    }

    public static synchronized void removeRenderable(Renderable renderable) {
        renderables.remove(renderable);
        if (renderable == null) {
            return;
        }
        renderable.remove();
    }

    public static void afterEntities(WorldRenderContext context) {
        long start = System.nanoTime();
        context.matrixStack().method_22903();
        class_243 pos = context.camera().method_19326();
        context.matrixStack().method_22904(-pos.field_1352, -pos.field_1351, -pos.field_1350);
        hasOutlines = false;
        renderables.forEach(renderable -> {
            if (renderable.requiresEntityOutlineShader()) {
                if (renderable.shouldRemove()) {
                    WorldRender.removeRenderable(renderable);
                    return;
                }
                if (renderable.shouldRender(context)) {
                    renderable.render(context);
                    hasOutlines = true;
                }
            }
        });
        context.matrixStack().method_22909();
        outlinesNs = System.nanoTime() - start;
    }

    private static void beforeDebugRender(WorldRenderContext context) {
        long start = System.nanoTime();
        context.matrixStack().method_22903();
        class_243 pos = context.camera().method_19326();
        context.matrixStack().method_22904(-pos.field_1352, -pos.field_1351, -pos.field_1350);
        renderables.forEach(renderable -> {
            if (renderable.requiresEntityOutlineShader()) {
                return;
            }
            if (renderable.shouldRemove()) {
                WorldRender.removeRenderable(renderable);
                return;
            }
            if (renderable.shouldRender(context)) {
                renderable.render(context);
            }
        });
        context.matrixStack().method_22909();
        renderTimeNs = System.nanoTime() - start;
    }

    public static int getAmountOfDrawables() {
        return renderables.size();
    }

    @Generated
    public static long getRenderTimeNs() {
        return renderTimeNs;
    }

    @Generated
    public static long getOutlinesNs() {
        return outlinesNs;
    }

    @Generated
    public static boolean isHasOutlines() {
        return hasOutlines;
    }

    static {
        WorldRenderEvents.BEFORE_DEBUG_RENDER.register(WorldRender::beforeDebugRender);
    }
}

