/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.render.hud;

import codes.cookies.mod.config.ConfigManager;
import codes.cookies.mod.render.hud.HudManager;
import codes.cookies.mod.render.hud.elements.HudElement;
import codes.cookies.mod.render.hud.internal.Action;
import codes.cookies.mod.render.hud.internal.BoundingBox;
import codes.cookies.mod.render.hud.internal.HudEditAction;
import codes.cookies.mod.render.hud.internal.HudElementSettings;
import codes.cookies.mod.render.hud.settings.HudElementSetting;
import codes.cookies.mod.render.hud.settings.HudElementSettingBuilder;
import codes.cookies.mod.utils.RenderUtils;
import codes.cookies.mod.utils.minecraft.SoundUtils;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.apache.commons.lang3.StringUtils;

public class HudEditScreen
extends class_437 {
    private HudElement currentlyHovered;
    private Action action = Action.NONE;
    private Action afterMoveAction = Action.NONE;
    private List<HudElementSetting> currentSettings = Collections.emptyList();
    private int sidebarSize = 0;
    private boolean isOnLeft;
    private HudEditAction editAction = HudEditAction.DEFAULT;
    private long lastEditActionChange = -1L;
    private long lastSizeChange = -1L;

    public HudEditScreen() {
        super((class_2561)class_2561.method_43473());
        this.getElements().forEach(hudElement -> hudElement.setHudEditAction(HudEditAction.DEFAULT));
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_57734();
        if (this.action == Action.NONE) {
            HudElement element = this.currentlyHovered;
            this.currentlyHovered = this.getElementUnder(mouseX, mouseY).orElse(null);
            if (element != this.currentlyHovered) {
                this.resetSettings();
                this.lastSizeChange = -1L;
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.action == Action.NONE) {
            stringBuilder.append("\u00a76Click \u00a77element to \u00a7bmove").append("\n");
            stringBuilder.append("\u00a76Click + scroll \u00a77or use \u00a7a+ \u00a77and \u00a7c- \u00a77to change \u00a7bscale").append("\n");
            stringBuilder.append("\u00a76Ctrl + Click \u00a77element for element \u00a7bsettings").append("\n");
            stringBuilder.append("\u00a77Press \u00a76H \u00a77to show all hud elements");
            if (this.lastEditActionChange + 2000L > System.currentTimeMillis()) {
                stringBuilder.append(" (\u00a7a%s\u00a77)".formatted(StringUtils.capitalize((String)this.editAction.name().replace("_", " ").toLowerCase())));
            }
            stringBuilder.append("\n");
        }
        if (this.currentlyHovered != null && this.lastSizeChange + 2000L > System.currentTimeMillis()) {
            stringBuilder.append("\u00a77Scale: \u00a7a%.2f".formatted(Float.valueOf(this.currentlyHovered.getScale()))).append("\n");
        }
        String string = stringBuilder.toString();
        int index = 0;
        Objects.requireNonNull(this.field_22793);
        int fontHeight = 9;
        for (class_5481 wrapLine : this.field_22793.method_1728((class_5348)class_2561.method_43470((String)string), this.field_22789)) {
            context.method_35719(this.field_22793, wrapLine, context.method_51421() / 2, context.method_51443() / 2 - fontHeight + fontHeight * index++, -5592406);
        }
        context.cm$withMatrix(stack -> {
            stack.method_46416(0.0f, 0.0f, 100.0f);
            this.getVisibleElements().forEach(hudElement -> this.renderElement(context, (HudElement)hudElement, delta));
        });
        if (this.currentlyHovered != null && this.action == Action.NONE) {
            context.method_51438(this.method_64506(), this.currentlyHovered.getName(), mouseX, mouseY);
        }
        if (this.action == Action.EDIT && this.currentlyHovered != null) {
            this.method_57734();
            context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"Editing ").method_10852(this.currentlyHovered.getName()).method_27693(" :3").method_27692(class_124.field_1080), context.method_51421() / 2, context.method_51443() / 2, -5592406);
            if (this.isOnLeft) {
                RenderUtils.renderBackgroundBox(context, 0, 0, this.sidebarSize, this.field_22790, -1);
            } else {
                RenderUtils.renderBackgroundBox(context, this.field_22789 - this.sidebarSize, 0, this.sidebarSize, this.field_22790, -1);
            }
            for (class_4068 drawable : this.field_33816) {
                drawable.method_25394(context, mouseX, mouseY, delta);
            }
            context.cm$withMatrix(stack -> {
                stack.method_46416(0.0f, 0.0f, 1000.0f);
                this.renderElement(context, this.currentlyHovered, delta);
            });
        }
    }

    public void method_25419() {
        super.method_25419();
        this.getElements().forEach(hudElement -> hudElement.setHudEditAction(HudEditAction.NONE));
        ConfigManager.saveConfig("hud-edit-screen");
    }

    private void renderElement(class_332 context, HudElement hudElement, float delta) {
        int elementX = hudElement.getX();
        int elementY = hudElement.getY();
        context.cm$withMatrix(stack -> {
            stack.method_46416((float)elementX, (float)elementY, 0.0f);
            stack.method_22905(hudElement.getScale(), hudElement.getScale(), 0.0f);
            if (!hudElement.getPosition().isBackground()) {
                if (this.currentlyHovered == hudElement) {
                    hudElement.getNormalizedBoundingBox().fill(context, -5526613);
                } else {
                    hudElement.getNormalizedBoundingBox().fill(context, -1426063360);
                }
            }
            hudElement.renderChecks(context, this.method_64506(), delta);
        });
        context.method_25294(0, 0, 0, 0, 0);
    }

    public boolean method_25400(char chr, int modifiers) {
        if (chr == '-' && this.action == Action.MOVE && this.currentlyHovered != null) {
            this.currentlyHovered.getPosition().applyScale(-0.1f);
            this.lastSizeChange = System.currentTimeMillis();
            return true;
        }
        if (chr == '+' && this.action == Action.MOVE && this.currentlyHovered != null) {
            this.currentlyHovered.getPosition().applyScale(0.1f);
            this.lastSizeChange = System.currentTimeMillis();
            return true;
        }
        return super.method_25400(chr, modifiers);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 72) {
            this.lastEditActionChange = System.currentTimeMillis();
            this.editAction = HudEditAction.values()[this.editAction.getNext()];
            this.getElements().forEach(hudElement -> hudElement.setHudEditAction(this.editAction));
            SoundUtils.playSound(class_3417.field_14627);
            return true;
        }
        if (keyCode == 256 && this.action == Action.EDIT) {
            this.action = Action.NONE;
            this.afterMoveAction = Action.NONE;
            this.resetSettings();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.action == Action.MOVE && this.currentlyHovered != null) {
            HudElementSettings position = this.currentlyHovered.getPosition();
            float relativeDeltaX = (float)(deltaX / (double)this.field_22789);
            float relativeDeltaY = (float)(deltaY / (double)this.field_22790);
            position.applyDelta(relativeDeltaX, relativeDeltaY);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.action == Action.MOVE) {
            this.action = this.afterMoveAction;
            if (this.action == Action.EDIT) {
                this.buildSettings();
            } else {
                this.resetSettings();
            }
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.action == Action.EDIT) {
            if (this.isOnLeft && mouseX < 120.0) {
                return true;
            }
            if (mouseX > (double)(this.field_22789 - 120)) {
                return true;
            }
            if (this.getElementUnder((int)mouseX, (int)mouseY).orElse(null) == this.currentlyHovered) {
                this.resetSettings();
                this.action = Action.MOVE;
                this.afterMoveAction = Action.EDIT;
                return true;
            }
        }
        if (this.currentlyHovered != null) {
            if (HudEditScreen.method_25441()) {
                this.action = Action.EDIT;
                this.afterMoveAction = Action.NONE;
                this.buildSettings();
                return true;
            }
            if (this.action == Action.EDIT) {
                this.action = Action.NONE;
                this.afterMoveAction = Action.NONE;
                this.resetSettings();
                return true;
            }
            this.action = Action.MOVE;
            this.afterMoveAction = Action.NONE;
            return true;
        }
        return true;
    }

    private void resetSettings() {
        this.currentSettings.forEach(x$0 -> this.method_37066((class_364)x$0));
        this.currentSettings = Collections.emptyList();
    }

    public void method_25410(class_310 client, int width, int height) {
        super.method_25410(client, width, height);
        this.buildSettings();
    }

    private void buildSettings() {
        this.resetSettings();
        if (this.currentlyHovered == null) {
            return;
        }
        int elementX = this.currentlyHovered.getX();
        this.isOnLeft = elementX > this.field_22789 / 2;
        HudElementSettingBuilder hudElementSettingBuilder = new HudElementSettingBuilder();
        this.currentlyHovered.buildSettings(hudElementSettingBuilder);
        List<HudElementSetting> build = hudElementSettingBuilder.build();
        build.forEach(HudElementSetting::init);
        this.sidebarSize = Math.max(build.stream().mapToInt(HudElementSetting::getWidth).max().orElse(0), 100) + 10;
        int xStart = this.isOnLeft ? 10 : this.field_22789 - this.sidebarSize + 10;
        int y = 20;
        int heightPer = build.stream().mapToInt(HudElementSetting::getHeight).max().orElse(0);
        if (heightPer == 0) {
            return;
        }
        for (HudElementSetting hudElementSetting : build) {
            hudElementSetting.setSidebarElementHeight(heightPer);
            hudElementSetting.setSidebarWidth(this.sidebarSize - 10);
            hudElementSetting.setX(xStart);
            hudElementSetting.setY(y);
            y += heightPer;
        }
        this.currentSettings = build;
        this.currentSettings.forEach(x$0 -> {
            HudElementSetting cfr_ignored_0 = (HudElementSetting)this.method_37063((class_364)x$0);
        });
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.action == Action.MOVE && this.currentlyHovered != null) {
            this.currentlyHovered.getPosition().applyScale((float)verticalAmount);
            this.lastSizeChange = System.currentTimeMillis();
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public Optional<HudElement> getElementUnder(int x, int y) {
        return this.getVisibleElements().stream().filter(hudElement -> this.expandBox(hudElement.getScaledBoundingBox(), 0.0f).isPointInsideBox(x, y)).findFirst();
    }

    public BoundingBox expandBox(BoundingBox box, float amount) {
        return box.expand(amount);
    }

    public List<HudElement> getVisibleElements() {
        return HudManager.elements.stream().filter(HudElement::shouldRender).toList();
    }

    public List<HudElement> getElements() {
        return HudManager.elements;
    }
}

