/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.render.hud.elements;

import codes.cookies.mod.render.hud.internal.Alignment;
import codes.cookies.mod.render.hud.internal.BoundingBox;
import codes.cookies.mod.render.hud.internal.HudEditAction;
import codes.cookies.mod.render.hud.internal.HudElementSettings;
import codes.cookies.mod.render.hud.settings.BooleanSetting;
import codes.cookies.mod.render.hud.settings.ColorSetting;
import codes.cookies.mod.render.hud.settings.EnumCycleSetting;
import codes.cookies.mod.render.hud.settings.HudElementSettingBuilder;
import codes.cookies.mod.render.hud.settings.HudElementSettingType;
import codes.cookies.mod.render.hud.settings.LiteralSetting;
import codes.cookies.mod.render.hud.settings.ValueSetting;
import lombok.Generated;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;

public abstract class HudElement {
    private final class_2960 identifier;
    private final HudElementSettings position = new HudElementSettings();
    protected HudEditAction hudEditAction = HudEditAction.NONE;

    public HudElement(class_2960 identifier) {
        this.identifier = identifier;
    }

    public abstract void render(class_332 var1, class_327 var2, float var3);

    public void renderBackground(class_332 drawContext) {
        if (this.position.isBackground()) {
            this.getNormalizedBoundingBox().fill(drawContext, this.position.getBackgroundColor());
        }
    }

    public abstract boolean shouldRender();

    public final void renderChecks(class_332 drawContext, class_327 textRenderer, float partialTicks) {
        if (!this.shouldRender()) {
            return;
        }
        this.render(drawContext, textRenderer, partialTicks);
    }

    public abstract int getWidth();

    public abstract int getHeight();

    public abstract class_2561 getName();

    protected void addBasicSetting(HudElementSettingBuilder builder) {
        builder.prependSetting(new EnumCycleSetting<Alignment>((class_2561)class_2561.method_43470((String)"Alignment"), (class_2561)class_2561.method_43470((String)""), this.position::getAlignment, this.position::setAlignment, HudElementSettingType.METADATA));
        builder.prependSetting(new ValueSetting((class_2561)class_2561.method_43470((String)"Scale: %.2f".formatted(Float.valueOf(this.getScale())))));
        builder.prependSetting(new ValueSetting((class_2561)class_2561.method_43470((String)("Y: " + this.getY()))));
        builder.prependSetting(new ValueSetting((class_2561)class_2561.method_43470((String)("X: " + this.getX()))));
        builder.prependSetting(new LiteralSetting(this.getName(), HudElementSettingType.METADATA));
    }

    protected void addConfigSetting(HudElementSettingBuilder builder) {
    }

    protected void addBackgroundSetting(HudElementSettingBuilder builder) {
        builder.addSetting(new BooleanSetting((class_2561)class_2561.method_43470((String)"Enable Background"), (class_2561)class_2561.method_43470((String)"Enables a background for the hud element"), this.position::isBackground, this.position::setBackground));
        builder.addSetting(new ColorSetting((class_2561)class_2561.method_43470((String)"Background Color"), (class_2561)class_2561.method_43470((String)"The background color for the hud element"), this.position::getColorValue, this.position::setColorValue, true));
    }

    public void buildSettings(HudElementSettingBuilder builder) {
        this.addBasicSetting(builder);
        this.addBackgroundSetting(builder);
        this.addConfigSetting(builder);
    }

    public int getX() {
        return this.position.clampX(this.getWidth());
    }

    public int getY() {
        return this.position.clampY(this.getHeight());
    }

    public void load(HudElementSettings value) {
        this.position.setScale(value.getScale());
        this.position.setX(value.getRelativeX());
        this.position.setY(value.getRelativeY());
        this.position.setAlignment(value.getAlignment());
        this.position.setBackground(value.isBackground());
        this.position.setBackgroundColor(value.getBackgroundColor());
    }

    public float getScale() {
        return this.position.getScale();
    }

    public BoundingBox getBoundingBox() {
        return new BoundingBox(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public BoundingBox getScaledBoundingBox() {
        return this.getBoundingBox().scale(this.getScale());
    }

    public BoundingBox getNormalizedBoundingBox() {
        return new BoundingBox(0.0f, 0.0f, this.getWidth(), this.getHeight());
    }

    @Generated
    public class_2960 getIdentifier() {
        return this.identifier;
    }

    @Generated
    public HudElementSettings getPosition() {
        return this.position;
    }

    @Generated
    public HudEditAction getHudEditAction() {
        return this.hudEditAction;
    }

    @Generated
    public void setHudEditAction(HudEditAction hudEditAction) {
        this.hudEditAction = hudEditAction;
    }
}

