/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.render.hud.internal;

import codes.cookies.mod.render.hud.internal.Alignment;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.awt.Color;
import lombok.Generated;
import net.minecraft.class_310;

public class HudElementSettings {
    public static Codec<HudElementSettings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("x").forGetter(HudElementSettings::getRelativeX), (App)Codec.FLOAT.fieldOf("y").forGetter(HudElementSettings::getRelativeY), (App)Codec.FLOAT.fieldOf("scale").forGetter(HudElementSettings::getScale), (App)Alignment.CODEC.fieldOf("alignment").forGetter(HudElementSettings::getAlignment), (App)Codec.BOOL.optionalFieldOf("background", (Object)false).forGetter(HudElementSettings::isBackground), (App)Codec.INT.optionalFieldOf("background_color", (Object)-1).forGetter(HudElementSettings::getBackgroundColor)).apply((Applicative)instance, HudElementSettings::new));
    private float x;
    private float y;
    private float scale = 1.0f;
    private Alignment alignment = Alignment.LEFT;
    private boolean background = false;
    private int backgroundColor = -1;

    public HudElementSettings() {
    }

    public HudElementSettings(float x, float y, float scale, Alignment alignment, boolean background, int backgroundColor) {
        this.x = x;
        this.y = y;
        this.scale = scale;
        this.alignment = alignment;
        this.background = background;
        this.backgroundColor = backgroundColor;
    }

    public float getRelativeX() {
        return this.x;
    }

    public int getX(int width) {
        return this.alignment.getX((int)(this.x * (float)this.getScreenWidth()), width);
    }

    public int clampX(int width) {
        return (int)Math.clamp((float)this.getX(width), 0.0f, Math.max((float)this.getScreenWidth() - (float)width * this.scale, 0.0f));
    }

    public float getRelativeY() {
        return this.y;
    }

    public int getY() {
        return (int)(this.y * (float)this.getScreenHeight());
    }

    public int clampY(int height) {
        return (int)Math.clamp((float)this.getY(), 0.0f, Math.max(0.0f, (float)this.getScreenHeight() - (float)height * this.scale));
    }

    public void applyDelta(float x, float y) {
        this.x = Math.clamp(this.x + x, 0.0f, 1.0f);
        this.y = Math.clamp(this.y + y, 0.0f, 1.0f);
    }

    public void setScale(float scale) {
        this.scale = Math.clamp(scale, 0.1f, 10.0f);
    }

    public void applyScale(float scale) {
        this.setScale(this.scale + scale);
    }

    private int getScreenWidth() {
        return class_310.method_1551().method_22683().method_4486();
    }

    private int getScreenHeight() {
        return class_310.method_1551().method_22683().method_4502();
    }

    public Color getColorValue() {
        return new Color(this.getBackgroundColor(), true);
    }

    public void setColorValue(Color color) {
        this.backgroundColor = color.getRGB();
    }

    @Generated
    public void setX(float x) {
        this.x = x;
    }

    @Generated
    public void setY(float y) {
        this.y = y;
    }

    @Generated
    public float getScale() {
        return this.scale;
    }

    @Generated
    public Alignment getAlignment() {
        return this.alignment;
    }

    @Generated
    public void setAlignment(Alignment alignment) {
        this.alignment = alignment;
    }

    @Generated
    public boolean isBackground() {
        return this.background;
    }

    @Generated
    public void setBackground(boolean background) {
        this.background = background;
    }

    @Generated
    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    @Generated
    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }
}

