/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.render.types;

import codes.cookies.mod.render.Renderable;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;

public record Composite(Renderable[] renderables) implements Renderable
{
    @Override
    public void render(WorldRenderContext context) {
        for (Renderable renderable : this.renderables) {
            if (renderable == null || !renderable.shouldRender(context)) continue;
            renderable.render(context);
        }
    }

    @Override
    public void load() {
        for (Renderable renderable : this.renderables) {
            if (renderable == null) continue;
            renderable.load();
        }
    }

    @Override
    public void remove() {
        for (Renderable renderable : this.renderables) {
            if (renderable == null) continue;
            renderable.remove();
        }
    }

    @Override
    public boolean shouldRemove() {
        for (Renderable renderable : this.renderables) {
            if (renderable == null || !renderable.shouldRemove()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean requiresEntityOutlineShader() {
        for (Renderable renderable : this.renderables) {
            if (renderable == null || !renderable.requiresEntityOutlineShader()) continue;
            return true;
        }
        return false;
    }
}

