/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.render.widgets;

import codes.cookies.mod.utils.accessors.TextRenderUtils;
import java.awt.Color;
import java.util.function.Consumer;
import lombok.Generated;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.function.Consumers;

public class ColorInputWidget
extends class_342 {
    private final boolean canHaveAlpha;
    private Color color;
    private Consumer<Color> callback = Consumers.nop();

    public ColorInputWidget(class_327 textRenderer, int height, Color text, boolean canHaveAlpha) {
        super(textRenderer, 10, height, (class_2561)class_2561.method_43470((String)ColorInputWidget.toText(text, canHaveAlpha)));
        this.update();
        this.canHaveAlpha = canHaveAlpha;
    }

    private int getBackgroundColor() {
        return 0xFF000000 | ~this.color.getRGB() & 0xFFFFFF;
    }

    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        int fullAlphaColor = this.getFullAlphaColor(this.color == null ? -1 : this.color.getRGB());
        context.method_25294(this.method_46426() - 2, this.method_46427() - 2, this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364() - 1, fullAlphaColor);
        context.method_25294(this.method_46426() - 1, this.method_46427() - 1, this.method_46426() + this.method_25368() - 1, this.method_46427() + this.method_25364() - 2, this.getBackgroundColor());
        TextRenderUtils.disableShadows();
        super.method_48579(context, mouseX, mouseY, delta);
        TextRenderUtils.enableShadows();
        context.method_51448().method_22903();
        context.method_51448().method_46416(0.0f, 0.0f, 10.0f);
        context.method_25294(this.method_46426() - 2, this.method_46427() + this.method_25364() - 2, this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364() - 1, fullAlphaColor);
        context.method_51448().method_22909();
    }

    public Color getColor() {
        return null;
    }

    public void setColor(Color color) {
        this.color = color;
        this.method_1868(this.getFullAlphaColor(this.color == null ? -1 : this.color.getRGB()));
        this.method_1852(this.toText(this.color));
    }

    private int getFullAlphaColor(int color) {
        return 0xFF000000 | color & 0xFFFFFF;
    }

    private void changeValue(String s) {
        Color color = this.toColor(s);
        if (color == null) {
            return;
        }
        this.method_1868(this.getFullAlphaColor(color.getRGB()));
        this.color = this.toColor(s);
        this.callback.accept(this.color);
    }

    public Color toColor(String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return null;
        }
        try {
            int color = Integer.parseUnsignedInt(text.substring(1), 16);
            return new Color(color, this.canHaveAlpha);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public void update() {
        this.method_1888(true);
        this.method_1868(this.getFullAlphaColor(this.color == null ? -1 : this.color.getRGB()));
        this.method_1863(this::changeValue);
        this.field_22763 = true;
        this.method_1862(true);
        this.method_1890(this::isAllowed);
        this.method_1888(true);
        this.method_1858(false);
        this.method_1880(this.canHaveAlpha ? 9 : 7);
        this.method_25358((this.canHaveAlpha ? 9 : 7) * 5 + 10);
        this.method_1852(this.toText(this.color));
        this.method_1883(0, false);
    }

    private static String toText(Color color, boolean canHaveAlpha) {
        if (color == null) {
            if (canHaveAlpha) {
                return "#00000000";
            }
            return "#000000";
        }
        return "#" + Integer.toHexString(canHaveAlpha ? color.getRGB() : color.getRGB() & 0xFFFFFF);
    }

    private String toText(Color color) {
        return ColorInputWidget.toText(color, this.canHaveAlpha);
    }

    private boolean isAllowed(String s) {
        if (!s.startsWith("#")) {
            return false;
        }
        if (s.length() == 1) {
            return true;
        }
        try {
            Integer.parseUnsignedInt(s.substring(1), 16);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Generated
    public void setCallback(Consumer<Color> callback) {
        this.callback = callback;
    }
}

