/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.repository;

import codes.cookies.mod.repository.RepositoryItem;
import codes.cookies.mod.repository.recipes.calculations.RecipeResult;
import codes.cookies.mod.utils.TextUtils;
import codes.cookies.mod.utils.items.CookiesDataComponentTypes;
import codes.cookies.mod.utils.skyblock.inventories.ItemBuilder;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;

public class Ingredient
implements RecipeResult<Ingredient> {
    private final String id;
    private final int amount;
    private final RepositoryItem repositoryItem;

    public Ingredient(String id, int amount) {
        this.id = id;
        this.amount = amount;
        this.repositoryItem = RepositoryItem.of(id);
    }

    @Override
    public RepositoryItem getRepositoryItemNotNull() {
        return Optional.ofNullable(RepositoryItem.of(this.id)).orElseGet(() -> RepositoryItem.createNotFound(this.id));
    }

    public static Ingredient of(String ingredient) {
        String[] split = ingredient.split(":");
        Object id = split[0];
        if (split.length == 3) {
            id = (String)id + ":" + split[1];
        }
        int amount = split.length == 1 ? 1 : Integer.parseInt(split[split.length - 1]);
        return new Ingredient((String)id, amount);
    }

    public static Set<Ingredient> mergeToSet(Iterable<Ingredient> ingredients) {
        return Ingredient.mergeIngredients(ingredients, Collectors.toSet());
    }

    public static <T> T mergeIngredients(Iterable<Ingredient> ingredients, Collector<Ingredient, ?, T> collector) {
        HashMap ingredientMap = new HashMap();
        ingredients.forEach(ingredient -> ingredientMap.merge(ingredient.getId(), ingredient, Ingredient::merge));
        return ingredientMap.values().stream().collect(collector);
    }

    public Ingredient merge(Ingredient other) {
        if (!this.getId().equals(other.getId())) {
            throw new IllegalArgumentException("Cannot merge ingredients with different ids");
        }
        return new Ingredient(this.id, this.amount + other.amount);
    }

    public static List<Ingredient> mergeToList(Iterable<Ingredient> ingredients) {
        return Ingredient.mergeIngredients(ingredients, Collectors.toList());
    }

    @Override
    public Ingredient multiply(int multiplier) {
        return new Ingredient(this.id, this.amount * multiplier);
    }

    public String getNameSafe() {
        return this.repositoryItem == null ? this.id : this.repositoryItem.getName().getString();
    }

    public class_1799 getAsItem() {
        if (this.id.equalsIgnoreCase("SKYBLOCK_COIN")) {
            return new ItemBuilder(class_1802.field_8397).setName((class_2561)TextUtils.literal("Coins", class_124.field_1065)).setLore(new class_2561[]{TextUtils.literal("%s Coins".formatted(NumberFormat.getInstance().format(this.amount)), class_124.field_1065)}).set(CookiesDataComponentTypes.CUSTOM_SLOT_TEXT, NumberFormat.getCompactNumberInstance().format(this.amount)).build();
        }
        if (this.repositoryItem != null) {
            class_1799 itemStack = this.repositoryItem.constructItemStack();
            itemStack.method_7939(this.amount);
            return itemStack;
        }
        return new ItemBuilder(class_1802.field_8077).setName((class_2561)TextUtils.translatable("cookies.not_found", class_124.field_1061)).setLore(new class_2561[]{TextUtils.translatableWithKeys("cookies.item_not_found", this.id)}).build();
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public int getAmount() {
        return this.amount;
    }

    @Override
    @Generated
    public RepositoryItem getRepositoryItem() {
        return this.repositoryItem;
    }
}

