/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.repository;

import codes.cookies.mod.config.categories.DevCategory;
import codes.cookies.mod.generated.BuildInfo;
import codes.cookies.mod.repository.RepositoryItem;
import codes.cookies.mod.repository.constants.RepositoryConstants;
import codes.cookies.mod.repository.recipes.Recipe;
import codes.cookies.mod.utils.UpdateChecker;
import codes.cookies.mod.utils.exceptions.ExceptionHandler;
import codes.cookies.mod.utils.json.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.Map;
import net.fabricmc.loader.api.metadata.version.VersionPredicate;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Repository {
    private static final Path ROOT = Path.of("cookies", new String[0]);
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"repository");

    public static void loadRepository() {
        if (!Files.exists(ROOT, new LinkOption[0])) {
            try {
                Files.createDirectories(ROOT, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            JsonObject index = (JsonObject)JsonUtils.CLEAN_GSON.fromJson(Repository.download("index"), JsonObject.class);
            UpdateChecker.setLatestModInfo(index.get("mod_info"));
            JsonObject requires = index.getAsJsonObject("requires");
            String modVersion = requires.get("mod_version").getAsString();
            VersionPredicate versionPredicate = ExceptionHandler.removeThrows(() -> VersionPredicate.parse((String)modVersion));
            if (versionPredicate.test((Object)BuildInfo.version)) {
                index.getAsJsonObject("files").entrySet().forEach(entry -> Repository.isUpToDate("", entry));
            }
        }
        catch (IOException e) {
            LOGGER.error("Error while loading cookies repository, continuing with old data.", (Throwable)e);
        }
        RepositoryItem.load(ROOT.resolve("items.json"));
        Recipe.load(ROOT.resolve("recipes.json"));
        RepositoryConstants.load(ROOT.resolve("constants"));
    }

    private static String getLocation() {
        String branch = DevCategory.dataRepoBranch;
        String owner_repo = DevCategory.dataRepo;
        return "https://raw.githubusercontent.com/%s/%s".formatted(owner_repo, branch);
    }

    private static String download(String file) throws IOException {
        URLConnection urlConnection = URI.create("%s/%s.json".formatted(Repository.getLocation(), file)).toURL().openConnection();
        urlConnection.connect();
        byte[] bytes = urlConnection.getInputStream().readAllBytes();
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private static void isUpToDate(String path, Map.Entry<String, JsonElement> entry) {
        String fileHash;
        String key = entry.getKey();
        if (entry.getValue().isJsonObject()) {
            entry.getValue().getAsJsonObject().entrySet().forEach(otherEntry -> Repository.isUpToDate(path + (String)entry.getKey() + "/", otherEntry));
            return;
        }
        Path folder = ROOT.resolve(path.isBlank() ? "." : path);
        Path file = folder.resolve(entry.getKey() + ".json");
        String hash = entry.getValue().getAsString();
        if (hash.equals(fileHash = Repository.getFileHash(file))) {
            return;
        }
        LOGGER.info("Downloading {}", (Object)(path + key));
        try {
            String download = Repository.download(path + key);
            if (!Files.exists(folder, new LinkOption[0])) {
                Files.createDirectories(folder, new FileAttribute[0]);
            }
            Files.writeString(file, (CharSequence)download, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    private static String getFileHash(Path resolve) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            if (!Files.exists(resolve, new LinkOption[0])) {
                return null;
            }
            byte[] digest = messageDigest.digest(Files.readAllBytes(resolve));
            return Repository.byteToHexString(digest);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static String byteToHexString(byte[] bytes) {
        StringBuilder result = new StringBuilder();
        for (byte singleByte : bytes) {
            result.append(String.format("%02x", singleByte));
        }
        return result.toString().toUpperCase(Locale.ROOT);
    }
}

