/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.repository;

import codes.cookies.mod.repository.Ingredient;
import codes.cookies.mod.repository.RepositoryItemMuseumData;
import codes.cookies.mod.repository.recipes.Recipe;
import codes.cookies.mod.utils.dev.FunctionUtils;
import codes.cookies.mod.utils.items.CookiesDataComponentTypes;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import lombok.Generated;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_7923;
import net.minecraft.class_8824;
import net.minecraft.class_9279;
import net.minecraft.class_9282;
import net.minecraft.class_9290;
import net.minecraft.class_9296;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryItem {
    public static final RepositoryItem EMPTY = RepositoryItem.createEmpty();
    public static final Codec<RepositoryItem> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("internal_id").forGetter(RepositoryItem::getInternalId), (App)Codec.STRING.optionalFieldOf("minecraft_id", (Object)"minecraft:barrier").forGetter(RepositoryItem::getMinecraftId), (App)class_8824.field_46597.optionalFieldOf("name", (Object)class_2561.method_43470((String)"<name not found>").method_27692(class_124.field_1061)).forGetter(RepositoryItem::getName), (App)class_8824.field_46597.listOf().optionalFieldOf("lore", Collections.emptyList()).forGetter(RepositoryItem::getLore), (App)Codec.STRING.optionalFieldOf("category").forGetter(FunctionUtils.wrapOptionalF(RepositoryItem::getCategory)), (App)Codec.INT.optionalFieldOf("color", (Object)0).forGetter(RepositoryItem::getColor), (App)Tier.CODEC.optionalFieldOf("tier", (Object)Tier.COMMON).forGetter(RepositoryItem::getTier), (App)SoulBoundType.CODEC.optionalFieldOf("soulboundtype", (Object)SoulBoundType.NONE).forGetter(RepositoryItem::getSoulboundtype), (App)Codec.DOUBLE.optionalFieldOf("value", (Object)0.0).forGetter(RepositoryItem::getValue), (App)Codec.DOUBLE.optionalFieldOf("motes_value", (Object)0.0).forGetter(RepositoryItem::getMotesValue), (App)Codec.BOOL.optionalFieldOf("museumable", (Object)false).forGetter(RepositoryItem::isMuseumable), (App)Codec.BOOL.optionalFieldOf("rift_transferrable", (Object)false).forGetter(RepositoryItem::isRiftTransferrable), (App)Codec.BOOL.optionalFieldOf("sackable", (Object)false).forGetter(RepositoryItem::isSackable), (App)Codec.STRING.optionalFieldOf("skin").forGetter(FunctionUtils.wrapOptionalF(RepositoryItem::getSkin))).apply((Applicative)instance, RepositoryItem::create));
    private static final Logger LOGGER = LoggerFactory.getLogger(RepositoryItem.class);
    private static final Logger log = LoggerFactory.getLogger(RepositoryItem.class);
    private static final Map<String, RepositoryItem> itemMap = new ConcurrentHashMap<String, RepositoryItem>();
    public static final Codec<RepositoryItem> ID_CODEC = Codec.STRING.xmap(s -> Optional.ofNullable(RepositoryItem.of(s)).orElse(EMPTY), RepositoryItem::getInternalId);
    private Set<Recipe> recipes;
    private Set<Recipe> usedInRecipeAsIngredient;
    private class_2561 name;
    @SerializedName(value="internal_id")
    private String internalId;
    @SerializedName(value="minecraft_id")
    private String minecraftId;
    private String category;
    private int color;
    private Tier tier;
    private double value;
    @SerializedName(value="motes_value")
    private double motesValue;
    private SoulBoundType soulboundtype;
    private boolean museumable;
    @SerializedName(value="rift_transferrable")
    private boolean riftTransferrable;
    private boolean sackable;
    private List<class_2561> lore;
    private String skin;
    private RepositoryItemMuseumData museumData;

    public static void load(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            System.err.println("Unable to load item list. (FILE_NOT_FOUND)");
            return;
        }
        try {
            JsonElement jsonElement = JsonParser.parseString((String)Files.readString(path, StandardCharsets.UTF_8));
            DataResult parse = CODEC.listOf().parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement);
            for (RepositoryItem repositoryItem : parse.resultOrPartial(arg_0 -> ((Logger)log).error(arg_0)).orElse(Collections.emptyList())) {
                repositoryItem.setRecipes(new HashSet<Recipe>());
                repositoryItem.setUsedInRecipeAsIngredient(new HashSet<Recipe>());
                repositoryItem.museumable = false;
                RepositoryItem put = itemMap.put(repositoryItem.internalId.toLowerCase(Locale.ROOT).replace(":", "/").replace("-", "/").replace(";", "/"), repositoryItem);
                if (put == null) continue;
                LOGGER.warn("Duplicate id detected {}", (Object)repositoryItem.internalId);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static RepositoryItem of(String id) {
        RepositoryItem repositoryItem = itemMap.get(id.toLowerCase(Locale.ROOT));
        if (repositoryItem != null) {
            return repositoryItem;
        }
        return itemMap.get(id.toLowerCase(Locale.ROOT).replace(":", "/").replace("-", "/").replace(";", "/"));
    }

    public static RepositoryItem ofOrEmpty(String id) {
        return Optional.ofNullable(itemMap.get(id.toLowerCase(Locale.ROOT))).orElseGet(() -> RepositoryItem.createNotFound(id));
    }

    public static Optional<RepositoryItem> ofName(String name) {
        String actualSearch = name.endsWith("x1") ? name.substring(0, name.length() - 3) : name;
        return itemMap.values().stream().filter(repositoryItem -> repositoryItem.getName().getString().equalsIgnoreCase(actualSearch)).findFirst();
    }

    private static RepositoryItem createEmpty() {
        return RepositoryItem.create("empty_" + String.valueOf(UUID.randomUUID()), "minecraft:barrier", (class_2561)class_2561.method_43470((String)"Not found").method_27692(class_124.field_1061), Collections.emptyList(), Optional.empty(), 0, Tier.ADMIN, SoulBoundType.SOULBOUND, 0.0, 0.0, false, false, false, Optional.empty());
    }

    public static RepositoryItem createNotFound(String id) {
        return RepositoryItem.create(id, "minecraft:barrier", (class_2561)class_2561.method_43470((String)"Not found (%s)".formatted(id)).method_27692(class_124.field_1061), Collections.emptyList(), Optional.empty(), 0, Tier.ADMIN, SoulBoundType.SOULBOUND, 0.0, 0.0, false, false, false, Optional.empty());
    }

    private static RepositoryItem create(String internalId, String minecraftId, class_2561 name, List<class_2561> lore, Optional<String> category, Integer color, Tier tier, SoulBoundType soulBoundType, Double value, Double motesValue, Boolean museumable, Boolean riftTransferrable, Boolean sackable, Optional<String> skin) {
        RepositoryItem item = new RepositoryItem();
        item.internalId = internalId;
        item.minecraftId = minecraftId;
        item.name = name;
        item.lore = lore;
        item.category = category.orElse(null);
        item.color = color;
        item.tier = tier;
        item.soulboundtype = soulBoundType;
        item.value = value;
        item.motesValue = motesValue;
        item.museumable = museumable;
        item.riftTransferrable = riftTransferrable;
        item.sackable = sackable;
        item.skin = skin.orElse(null);
        item.recipes = Collections.emptySet();
        item.usedInRecipeAsIngredient = Collections.emptySet();
        return item;
    }

    public static <T> Function<T, RepositoryItem> getMappedOrEmpty(Function<T, class_1799> mapper) {
        return t -> RepositoryItem.getOrEmpty((class_1799)mapper.apply(t));
    }

    @NotNull
    public static RepositoryItem getOrEmpty(class_1799 item) {
        if (item.method_57826(CookiesDataComponentTypes.REPOSITORY_ITEM)) {
            return Optional.ofNullable((RepositoryItem)item.method_57824(CookiesDataComponentTypes.REPOSITORY_ITEM)).orElse(EMPTY);
        }
        return EMPTY;
    }

    public Optional<RepositoryItemMuseumData> getMuseumData() {
        return Optional.ofNullable(this.museumData);
    }

    public RepositoryItemMuseumData getOrCreateMuseumData() {
        if (this.museumData == null) {
            this.museumData = new RepositoryItemMuseumData();
        }
        return this.museumData;
    }

    public boolean equals(Object obj) {
        Object object = obj;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_2960.class, Ingredient.class, RepositoryItem.class}, (Object)object, n)) {
            case -1 -> false;
            case 0 -> {
                class_2960 identifier = (class_2960)object;
                if ((identifier.method_12836().equalsIgnoreCase("cookies") || identifier.method_12836().equalsIgnoreCase("skyblock")) && identifier.method_12832().equals(this.internalId)) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                Ingredient ingredient = (Ingredient)object;
                yield this.equals(ingredient.getRepositoryItem());
            }
            case 2 -> {
                RepositoryItem repositoryItem = (RepositoryItem)object;
                yield Objects.equals(this.internalId, repositoryItem.getInternalId());
            }
            default -> super.equals(obj);
        };
    }

    public class_2561 getFormattedName() {
        if (this.tier == null) {
            return this.name.method_27661();
        }
        if (this.name.method_10866().method_10967()) {
            return this.name.method_27661().method_10862(class_2583.field_24360.method_27706(this.tier.formatting));
        }
        return this.name.method_27661();
    }

    public boolean isMuseumable() {
        return this.museumData != null && this.museumData.getDonationType() != RepositoryItemMuseumData.DonationType.NONE;
    }

    public class_1799 constructItemStack() {
        class_1799 itemStack = new class_1799((class_1935)class_7923.field_41178.method_63535(class_2960.method_60654((String)this.minecraftId)));
        itemStack.method_57379(class_9334.field_49631, (Object)this.name.method_27661().method_27694(style -> style.method_10978(Boolean.valueOf(false))));
        itemStack.method_57379(CookiesDataComponentTypes.REPOSITORY_ITEM, (Object)this);
        PropertyMap propertyMap = new PropertyMap();
        class_9296 component = new class_9296(new GameProfile(UUID.randomUUID(), "meowora"));
        component.comp_2412().put((Object)"textures", (Object)new Property("textures", this.skin));
        itemStack.method_57379(class_9334.field_49617, (Object)component);
        itemStack.method_57379(class_9334.field_49632, (Object)new class_9290(this.lore, this.lore));
        itemStack.method_57379(CookiesDataComponentTypes.SKYBLOCK_ID, (Object)this.internalId);
        itemStack.method_57379(class_9334.field_49644, (Object)new class_9282(this.color, false));
        itemStack.method_57381(class_9334.field_49636);
        itemStack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)this.createNbt()));
        return itemStack;
    }

    private class_2487 createNbt() {
        class_2487 nbtCompound = new class_2487();
        nbtCompound.method_10582("id", this.internalId);
        return nbtCompound;
    }

    @Generated
    public Set<Recipe> getRecipes() {
        return this.recipes;
    }

    @Generated
    public Set<Recipe> getUsedInRecipeAsIngredient() {
        return this.usedInRecipeAsIngredient;
    }

    @Generated
    public class_2561 getName() {
        return this.name;
    }

    @Generated
    public String getInternalId() {
        return this.internalId;
    }

    @Generated
    public String getMinecraftId() {
        return this.minecraftId;
    }

    @Generated
    public String getCategory() {
        return this.category;
    }

    @Generated
    public int getColor() {
        return this.color;
    }

    @Generated
    public Tier getTier() {
        return this.tier;
    }

    @Generated
    public double getValue() {
        return this.value;
    }

    @Generated
    public double getMotesValue() {
        return this.motesValue;
    }

    @Generated
    public SoulBoundType getSoulboundtype() {
        return this.soulboundtype;
    }

    @Generated
    public boolean isRiftTransferrable() {
        return this.riftTransferrable;
    }

    @Generated
    public boolean isSackable() {
        return this.sackable;
    }

    @Generated
    public List<class_2561> getLore() {
        return this.lore;
    }

    @Generated
    public String getSkin() {
        return this.skin;
    }

    @Generated
    public static Map<String, RepositoryItem> getItemMap() {
        return itemMap;
    }

    @Generated
    void setRecipes(Set<Recipe> recipes) {
        this.recipes = recipes;
    }

    @Generated
    void setUsedInRecipeAsIngredient(Set<Recipe> usedInRecipeAsIngredient) {
        this.usedInRecipeAsIngredient = usedInRecipeAsIngredient;
    }

    public static enum Tier implements class_3542
    {
        COMMON(class_124.field_1068),
        UNCOMMON(class_124.field_1060),
        RARE(class_124.field_1078),
        EPIC(class_124.field_1064),
        LEGENDARY(class_124.field_1065),
        MYTHIC(class_124.field_1076),
        SPECIAL(class_124.field_1061),
        VERY_SPECIAL(class_124.field_1061),
        ULTIMATE(class_124.field_1079),
        ADMIN(class_124.field_1079);

        public static final Codec<Tier> CODEC;
        private final class_124 formatting;

        private Tier(class_124 formatting) {
            this.formatting = formatting;
        }

        public String method_15434() {
            return this.name();
        }

        @Generated
        public class_124 getFormatting() {
            return this.formatting;
        }

        static {
            CODEC = class_3542.method_49454(Tier::values, String::toUpperCase).orElse((Object)COMMON);
        }
    }

    public static enum SoulBoundType implements class_3542
    {
        COOP,
        SOULBOUND,
        NONE;

        public static final Codec<SoulBoundType> CODEC;

        public String method_15434() {
            return this.name();
        }

        static {
            CODEC = class_3542.method_53955(SoulBoundType::values);
        }
    }
}

