/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.repository;

import codes.cookies.mod.repository.constants.MuseumData;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class RepositoryItemMuseumData {
    private List<MuseumData.ArmorItem> armorItems;
    private MuseumData.MuseumItem weapon = null;
    private MuseumData.MuseumItem rarity = null;
    private boolean canBeDonatedToSpecial = false;
    @NotNull
    private DonationType donationType = DonationType.NONE;

    public void addArmorItems(MuseumData.ArmorItem armorItem) {
        if (this.armorItems == null) {
            this.armorItems = new ArrayList<MuseumData.ArmorItem>();
        }
        this.armorItems.add(armorItem);
        this.donationType = DonationType.ARMOR;
    }

    public void addWeapon(MuseumData.MuseumItem weapon) {
        this.weapon = weapon;
        this.donationType = DonationType.WEAPON;
    }

    public void addRarity(MuseumData.MuseumItem rarity) {
        this.donationType = DonationType.RARITY;
        this.rarity = rarity;
    }

    public void setSpecial() {
        this.donationType = DonationType.SPECIAL;
        this.canBeDonatedToSpecial = true;
    }

    public Optional<List<MuseumData.ArmorItem>> getArmorItems() {
        return Optional.ofNullable(this.armorItems);
    }

    public Optional<MuseumData.MuseumItem> getWeapon() {
        return Optional.ofNullable(this.weapon);
    }

    public Optional<MuseumData.MuseumItem> getRarity() {
        return Optional.ofNullable(this.rarity);
    }

    public boolean canBeDonatedToSpecial() {
        return this.canBeDonatedToSpecial;
    }

    @NotNull
    @Generated
    public DonationType getDonationType() {
        return this.donationType;
    }

    public static enum DonationType {
        ARMOR,
        WEAPON,
        RARITY,
        SPECIAL,
        NONE;

    }
}

