/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.repository.constants;

import codes.cookies.mod.repository.Ingredient;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;

public class ComposterUpgrades {
    private final List<CompostUpgrade> speed;
    private final List<CompostUpgrade> multiDrop;
    private final List<CompostUpgrade> fuelCap;
    private final List<CompostUpgrade> organicMatterCap;
    private final List<CompostUpgrade> costReduction;

    public ComposterUpgrades(JsonObject jsonObject) {
        if (jsonObject == null) {
            throw new UnsupportedOperationException();
        }
        this.speed = this.getUpgrades(jsonObject.getAsJsonArray("speed"));
        this.multiDrop = this.getUpgrades(jsonObject.getAsJsonArray("multi_drop"));
        this.fuelCap = this.getUpgrades(jsonObject.getAsJsonArray("fuel_cap"));
        this.organicMatterCap = this.getUpgrades(jsonObject.getAsJsonArray("organic_matter_cap"));
        this.costReduction = this.getUpgrades(jsonObject.getAsJsonArray("cost_reduction"));
    }

    private List<CompostUpgrade> getUpgrades(JsonArray jsonElements) {
        LinkedList<CompostUpgrade> list = new LinkedList<CompostUpgrade>();
        for (JsonElement jsonElement : jsonElements) {
            if (!jsonElement.isJsonObject()) continue;
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            int copper = jsonObject.get("copper").getAsInt();
            LinkedList<Ingredient> upgradeList = new LinkedList<Ingredient>();
            JsonObject costObject = jsonObject.getAsJsonObject("cost");
            for (String key : costObject.keySet()) {
                upgradeList.add(new Ingredient(key, costObject.get(key).getAsInt()));
            }
            list.add(new CompostUpgrade(copper, upgradeList));
        }
        return list;
    }

    @Generated
    public List<CompostUpgrade> getSpeed() {
        return this.speed;
    }

    @Generated
    public List<CompostUpgrade> getMultiDrop() {
        return this.multiDrop;
    }

    @Generated
    public List<CompostUpgrade> getFuelCap() {
        return this.fuelCap;
    }

    @Generated
    public List<CompostUpgrade> getOrganicMatterCap() {
        return this.organicMatterCap;
    }

    @Generated
    public List<CompostUpgrade> getCostReduction() {
        return this.costReduction;
    }

    public record CompostUpgrade(int copper, List<Ingredient> cost) {
    }
}

