/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.repository.constants;

import codes.cookies.mod.repository.RepositoryItem;
import codes.cookies.mod.utils.Either;
import codes.cookies.mod.utils.Result;
import codes.cookies.mod.utils.cookies.CookiesUtils;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record MuseumData(List<MuseumItem> weapons, List<ArmorItem> armor, List<MuseumItem> rarity, List<RepositoryItem> special, Set<RepositoryItem> museumItems, Map<String, String> exceptions) {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MuseumData.class);
    public static Codec<MuseumData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MuseumItem.CODEC.listOf().fieldOf("museum_weapons").forGetter(MuseumData::weapons), (App)ArmorItem.CODEC.listOf().fieldOf("museum_armor").forGetter(MuseumData::armor), (App)MuseumItem.CODEC.listOf().fieldOf("museum_rarity").forGetter(MuseumData::rarity), (App)RepositoryItem.ID_CODEC.listOf().fieldOf("museum_special").forGetter(MuseumData::special), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).fieldOf("armor_exceptions").forGetter(MuseumData::exceptions)).apply((Applicative)instance, MuseumData::create));

    public static MuseumData load(JsonObject jsonObject) {
        DataResult parse = CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject);
        if (parse.isSuccess()) {
            return (MuseumData)parse.getOrThrow();
        }
        String message = ((DataResult.Error)parse.error().orElseThrow()).message();
        log.error("Can't load museum data: {}", (Object)message);
        return new MuseumData(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptySet(), Collections.emptyMap());
    }

    private static MuseumData create(List<MuseumItem> museumWeapons, List<ArmorItem> armorItems, List<MuseumItem> museumRarity, List<RepositoryItem> museumSpecial, Map<String, String> armorExceptions) {
        HashSet<RepositoryItem> museumItems = new HashSet<RepositoryItem>();
        for (MuseumItem museumWeapon : museumWeapons) {
            museumWeapon.item.getOrCreateMuseumData().addWeapon(museumWeapon);
            museumItems.add(museumWeapon.item);
        }
        for (MuseumItem museumItem : museumRarity) {
            museumItem.item.getOrCreateMuseumData().addRarity(museumItem);
            museumItems.add(museumItem.item);
        }
        for (ArmorItem armorItem : armorItems) {
            for (RepositoryItem armorId : armorItem.armorIds) {
                armorId.getOrCreateMuseumData().addArmorItems(armorItem);
            }
            museumItems.addAll(armorItem.armorIds);
        }
        for (RepositoryItem special : museumSpecial) {
            special.getOrCreateMuseumData().setSpecial();
        }
        museumItems.addAll(museumSpecial);
        return new MuseumData(museumWeapons, armorItems, museumRarity, museumSpecial, museumItems, new HashMap<String, String>(armorExceptions));
    }

    public Result<Either<MuseumItem, ArmorItem>, MuseumDataError> getItemByName(String name) {
        String lowerCaseName = CookiesUtils.stripColor(name.toLowerCase().replaceAll("[\u2716\u2714]", "")).trim();
        List<String> armorNames = Arrays.asList("set", "suit", "armor", "outfit", "equipment", "'s special armor", "'s armor", "armor of", "tuxedo");
        if (armorNames.stream().anyMatch(lowerCaseName::contains)) {
            Optional<String> first = armorNames.stream().map(armor -> lowerCaseName.replaceAll((String)armor, "")).min(Comparator.comparingInt(String::length));
            String modifiedName = first.get();
            String id = this.exceptions.getOrDefault(lowerCaseName, modifiedName).trim().toUpperCase().replaceAll(" ", "_");
            String secondaryId = lowerCaseName.trim().toUpperCase().replaceAll(" ", "_");
            for (ArmorItem armorItem : this.armor) {
                if (!armorItem.id.equals(id) && !armorItem.id.equals(secondaryId)) continue;
                return Result.success(Either.right(armorItem));
            }
            return Result.error(new MuseumDataError(MuseumDataError.MuseumDataErrorType.NO_ARMOR_FOUND, name));
        }
        Optional<RepositoryItem> repositoryItem = RepositoryItem.ofName(lowerCaseName);
        if (repositoryItem.isEmpty()) {
            return Result.error(new MuseumDataError(MuseumDataError.MuseumDataErrorType.ITEM_NOT_FOUND, name));
        }
        RepositoryItem item = repositoryItem.get();
        for (MuseumItem weapon : this.weapons) {
            if (weapon.item != item && !weapon.mappedItems.contains(item)) continue;
            return Result.success(Either.left(weapon));
        }
        for (MuseumItem museumItem : this.rarity) {
            if (museumItem.item != item && !museumItem.mappedItems.contains(item)) continue;
            return Result.success(Either.left(museumItem));
        }
        return Result.error(new MuseumDataError(MuseumDataError.MuseumDataErrorType.NO_MATCHING_MUSEUM_FOUND));
    }

    public record MuseumItem(RepositoryItem item, @Nullable RepositoryItem parent, List<RepositoryItem> mappedItems) {
        public static Codec<MuseumItem> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RepositoryItem.ID_CODEC.fieldOf("id").forGetter(MuseumItem::item), (App)RepositoryItem.ID_CODEC.optionalFieldOf("parent", (Object)RepositoryItem.EMPTY).forGetter(MuseumItem::parent), (App)RepositoryItem.ID_CODEC.listOf().optionalFieldOf("mapped_item_ids", Collections.emptyList()).forGetter(MuseumItem::mappedItems)).apply((Applicative)instance, MuseumItem::of));

        public static MuseumItem of(RepositoryItem item, @Nullable RepositoryItem parent, List<RepositoryItem> mappedItems) {
            if (parent == RepositoryItem.EMPTY) {
                return new MuseumItem(item, null, mappedItems);
            }
            return new MuseumItem(item, parent, mappedItems);
        }
    }

    public record ArmorItem(String id, List<RepositoryItem> armorIds, @Nullable String parent) {
        public static Codec<ArmorItem> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("armor_id").forGetter(ArmorItem::id), (App)RepositoryItem.ID_CODEC.listOf().optionalFieldOf("items", Collections.emptyList()).forGetter(ArmorItem::armorIds), (App)Codec.STRING.optionalFieldOf("parent", (Object)"").forGetter(ArmorItem::parent)).apply((Applicative)instance, ArmorItem::of));

        public static ArmorItem of(String id, List<RepositoryItem> armorIds, @Nullable String parent) {
            if (parent == null || parent.isBlank()) {
                return new ArmorItem(id, armorIds, null);
            }
            return new ArmorItem(id, armorIds, parent);
        }
    }

    public record MuseumDataError(MuseumDataErrorType errorType, Optional<String> message) {
        public MuseumDataError(MuseumDataErrorType errorType) {
            this(errorType, Optional.empty());
        }

        public MuseumDataError(MuseumDataErrorType errorType, String message) {
            this(errorType, Optional.of(message));
        }

        public static enum MuseumDataErrorType {
            ITEM_NOT_FOUND,
            NO_ARMOR_FOUND,
            NO_MATCHING_MUSEUM_FOUND;

        }
    }
}

