/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.repository.constants;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlotPrice {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"plot_price");
    List<Cost> center;
    List<Cost> middle;
    List<Cost> edges;
    List<Cost> corners;

    public PlotPrice(JsonObject jsonObject) {
        if (jsonObject == null) {
            return;
        }
        this.center = this.read(jsonObject.getAsJsonArray("center"));
        this.middle = this.read(jsonObject.getAsJsonArray("middle"));
        this.edges = this.read(jsonObject.getAsJsonArray("edges"));
        this.corners = this.read(jsonObject.getAsJsonArray("corners"));
    }

    public List<Cost> getByIndex(int index) {
        return switch (index) {
            case 0 -> this.center;
            case 1 -> this.middle;
            case 2 -> this.edges;
            case 3 -> this.corners;
            default -> Collections.emptyList();
        };
    }

    private List<Cost> read(JsonArray json) {
        ArrayList<Cost> costs = new ArrayList<Cost>(json.size());
        for (JsonElement jsonElement : json) {
            if (jsonElement instanceof JsonObject) {
                JsonObject jsonObject = (JsonObject)jsonElement;
                costs.add(new Cost(jsonObject.get("amount").getAsInt(), jsonObject.get("bundle").getAsBoolean()));
                continue;
            }
            if (!(jsonElement instanceof JsonPrimitive)) continue;
            JsonPrimitive jsonPrimitive = (JsonPrimitive)jsonElement;
            if (!jsonPrimitive.isNumber()) {
                LOGGER.error("Plot price cannot contain non numbers");
                continue;
            }
            costs.add(new Cost(jsonPrimitive.getAsInt(), false));
        }
        return costs;
    }

    public record Cost(int amount, boolean bundle) {
    }
}

