/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.repository.constants;

import codes.cookies.mod.repository.constants.ComposterUpgrades;
import codes.cookies.mod.repository.constants.MuseumData;
import codes.cookies.mod.repository.constants.PlotPrice;
import codes.cookies.mod.repository.constants.RepositoryConstantsHelper;
import codes.cookies.mod.repository.constants.Warps;
import codes.cookies.mod.repository.constants.dungeons.DungeonConstants;
import codes.cookies.mod.repository.constants.mining.Hotm;
import codes.cookies.mod.repository.constants.mining.ShaftCorpseLocations;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_2338;

public class RepositoryConstants {
    public static Hotm hotm;
    public static PlotPrice plotPrice;
    public static ComposterUpgrades composterUpgrades;
    public static Warps warps;
    public static List<class_2338> modLocations;
    public static MuseumData museumData;

    public static void load(Path path) {
        hotm = new Hotm(RepositoryConstantsHelper.resolve(path.resolve("hotm.json"), JsonObject.class));
        plotPrice = new PlotPrice(RepositoryConstantsHelper.resolve(path.resolve("plot_cost.json"), JsonObject.class));
        composterUpgrades = new ComposterUpgrades(RepositoryConstantsHelper.resolve(path.resolve("compost_upgrades.json"), JsonObject.class));
        warps = new Warps(RepositoryConstantsHelper.resolve(path.resolve("warps.json"), JsonArray.class));
        modLocations = RepositoryConstants.loadModLocations(RepositoryConstantsHelper.resolve(path.resolve("mod_locations.json"), JsonArray.class));
        museumData = MuseumData.load(RepositoryConstantsHelper.resolve(path.resolve("museum_data.json"), JsonObject.class));
        DungeonConstants.load(path.resolve("dungeons"));
        ShaftCorpseLocations.load(RepositoryConstantsHelper.resolve(path.resolve("mining/shaft_corpses.json"), JsonArray.class));
    }

    private static List<class_2338> loadModLocations(JsonArray json) {
        DataResult parse = class_2338.field_25064.listOf().parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
        if (parse.isError()) {
            RepositoryConstantsHelper.LOGGER.warn("Failed to load mod locations D: {}", (Object)parse.error().map(DataResult.Error::message).orElse("<no message>"));
            return Collections.emptyList();
        }
        return new ArrayList<class_2338>((Collection)parse.getOrThrow());
    }
}

