/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.repository.constants.dungeons;

import codes.cookies.mod.features.dungeons.solver.puzzle.WaterBoardPuzzleSolver;
import codes.cookies.mod.repository.constants.RepositoryConstantsHelper;
import codes.cookies.mod.repository.constants.dungeons.WaterEntry;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class DungeonConstants {
    public static List<WaterEntry> waterEntries;
    public static Map<String, List<String>> quizAnswers;
    private static final Codec<Map<String, List<String>>> QUIZ_CODEC;

    public static void load(Path path) {
        waterEntries = WaterEntry.load(RepositoryConstantsHelper.resolve(path.resolve("water_times.json"), JsonArray.class));
        quizAnswers = DungeonConstants.loadQuizAnswers(RepositoryConstantsHelper.resolve(path.resolve("quiz_answers.json"), JsonObject.class));
    }

    private static Map<String, List<String>> loadQuizAnswers(JsonObject json) {
        DataResult parse = QUIZ_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
        if (parse.isError()) {
            RepositoryConstantsHelper.LOGGER.warn("Failed to load quiz answers D: {}", (Object)parse.error().map(DataResult.Error::message).orElse("<no message>"));
            return Collections.emptyMap();
        }
        return (Map)parse.getOrThrow();
    }

    public static Optional<WaterEntry> getFor(WaterBoardPuzzleSolver.Variant variant, String type) {
        for (WaterEntry entry : waterEntries) {
            if (!entry.variant().equals((Object)variant) || !entry.closed().equals(type)) continue;
            return Optional.of(entry);
        }
        return Optional.empty();
    }

    static {
        QUIZ_CODEC = Codec.dispatchedMap((Codec)Codec.STRING, s -> Codec.STRING.listOf());
    }
}

