/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.repository.constants.dungeons;

import codes.cookies.mod.features.dungeons.solver.puzzle.WaterBoardPuzzleSolver;
import codes.cookies.mod.repository.constants.RepositoryConstantsHelper;
import com.google.gson.JsonArray;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public record WaterEntry(WaterBoardPuzzleSolver.Variant variant, String closed, Map<WaterBoardPuzzleSolver.LeverType, List<Double>> times) {
    public static final Codec<WaterEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)WaterBoardPuzzleSolver.Variant.CODEC.fieldOf("variant").forGetter(WaterEntry::variant), (App)Codec.STRING.fieldOf("type").forGetter(WaterEntry::closed), (App)Codec.dispatchedMap(WaterBoardPuzzleSolver.LeverType.CODEC, leverType -> Codec.DOUBLE.listOf()).fieldOf("times").forGetter(WaterEntry::times)).apply((Applicative)instance, WaterEntry::new));
    public static final Codec<List<WaterEntry>> LIST_CODEC = CODEC.listOf();

    public static List<WaterEntry> load(@Nullable JsonArray resolve) {
        DataResult parse = LIST_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)resolve);
        if (parse.isError()) {
            RepositoryConstantsHelper.LOGGER.warn("Failed to load water times D: {}", (Object)parse.error().map(DataResult.Error::message).orElse("<no message>"));
            return List.of();
        }
        return (List)parse.getOrThrow();
    }
}

