/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.repository.constants.mining;

import codes.cookies.mod.data.mining.PowderType;
import codes.cookies.mod.utils.json.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hotm {
    private static final Logger LOGGER = LoggerFactory.getLogger(Hotm.class);
    private final Map<String, Perk> perks = new HashMap<String, Perk>();

    public Hotm(JsonObject jsonObject) {
        if (jsonObject == null) {
            return;
        }
        jsonObject.entrySet().forEach(entry -> {
            if (((JsonElement)entry.getValue()).isJsonObject()) {
                this.addPerk((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsJsonObject());
            }
        });
    }

    private void addPerk(String name, JsonObject object) {
        Perk perk = (Perk)JsonUtils.CLEAN_GSON.fromJson((JsonElement)object, Perk.class);
        this.perks.put(name, perk);
    }

    public Perk getPerk(String name) {
        return this.perks.get(name);
    }

    public record Perk(@SerializedName(value="type") PowderType powderType, int[] levels) {
        public int calculateNextN(int n, int start) {
            int amount = 0;
            for (int i = Math.max(0, start - 1); i < Math.min(Math.max(0, start - 1) + n, this.levels.length); ++i) {
                amount += this.levels[i];
            }
            return amount;
        }

        public int calculateTotal(int start) {
            int amount = 0;
            for (int i = Math.max(0, start - 1); i < this.levels.length; ++i) {
                amount += this.levels[i];
            }
            return amount;
        }

        public boolean isOverMax(int i) {
            return this.levels.length < i;
        }
    }
}

