/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.repository.constants.mining;

import com.google.gson.JsonArray;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import net.minecraft.class_2338;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShaftCorpseLocations {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShaftCorpseLocations.class);
    private static final List<ShaftLocations> locations = new ArrayList<ShaftLocations>();

    public static void load(JsonArray jsonObject) {
        DataResult parse = CachedShaftLocations.LIST_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject);
        if (parse.isSuccess()) {
            locations.addAll((Collection)parse.getOrThrow());
            return;
        }
        String message = ((DataResult.Error)parse.error().orElseThrow()).message();
        log.error("Can't load museum data: {}", (Object)message);
    }

    public static Optional<ShaftLocations> getById(String id) {
        return ShaftCorpseLocations.locations.stream().filter(locations -> locations.id().equals(id.trim())).findFirst();
    }

    public static List<ShaftLocations> getCached() {
        return locations;
    }

    public static ShaftLocations getCachedOrCreate(String id) {
        return ShaftCorpseLocations.getById(id).orElseGet(() -> ShaftCorpseLocations.register(new MutableShaftLocations(id)));
    }

    private static ShaftLocations register(MutableShaftLocations mutableShaftLocations) {
        locations.add(mutableShaftLocations);
        return mutableShaftLocations;
    }

    public record CachedShaftLocations(String id, List<class_2338> corpseLocations) implements ShaftLocations
    {
        public static final Codec<ShaftLocations> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("id").forGetter(ShaftLocations::id), (App)class_2338.field_25064.listOf().fieldOf("locations").forGetter(ShaftLocations::corpseLocations)).apply((Applicative)instance, CachedShaftLocations::create));
        public static final Codec<List<ShaftLocations>> LIST_CODEC = CODEC.listOf();

        private static ShaftLocations create(String s, List<class_2338> blockPos) {
            return new CachedShaftLocations(s, new ArrayList<class_2338>(blockPos));
        }

        @Override
        public boolean cached() {
            return true;
        }
    }

    public static interface ShaftLocations {
        public String id();

        public List<class_2338> corpseLocations();

        public boolean cached();
    }

    public static class MutableShaftLocations
    implements ShaftLocations {
        private final String id;
        private final List<class_2338> corpseLocations;

        public MutableShaftLocations(String id) {
            this.id = id;
            this.corpseLocations = new ArrayList<class_2338>();
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public List<class_2338> corpseLocations() {
            return this.corpseLocations;
        }

        @Override
        public boolean cached() {
            return false;
        }
    }
}

