/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.repository.recipes;

import codes.cookies.mod.repository.Ingredient;
import codes.cookies.mod.repository.recipes.Recipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;

public class CraftRecipe
implements Recipe {
    private final Ingredient[] ingredients;
    private final Ingredient output;

    public CraftRecipe(JsonObject jsonObject) {
        JsonArray ingredients = jsonObject.get("ingredients").getAsJsonArray();
        HashMap<String, Ingredient> ingredientMap = new HashMap<String, Ingredient>();
        for (JsonElement element : ingredients) {
            Ingredient ingredient = Ingredient.of(element.getAsString());
            if (!ingredientMap.containsKey(ingredient.getId())) {
                ingredientMap.put(ingredient.getId(), ingredient);
                continue;
            }
            ingredientMap.put(ingredient.getId(), ((Ingredient)ingredientMap.remove(ingredient.getId())).merge(ingredient));
        }
        this.ingredients = new Ingredient[ingredientMap.size()];
        ingredientMap.values().toArray(this.ingredients);
        this.output = jsonObject.get("out") != null ? Ingredient.of(jsonObject.get("out").getAsString()) : null;
    }

    @Override
    public Ingredient[] getIngredients() {
        return this.ingredients;
    }

    @Override
    public Ingredient getOutput() {
        return this.output;
    }
}

