/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.repository.recipes;

import codes.cookies.mod.data.profile.ProfileData;
import codes.cookies.mod.data.profile.ProfileStorage;
import codes.cookies.mod.repository.Ingredient;
import codes.cookies.mod.repository.recipes.Recipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import lombok.Generated;

public class ForgeRecipe
implements Recipe {
    private final ForgeRecipeType type;
    private final long duration;
    private final Ingredient[] ingredients;
    private final Ingredient output;

    public ForgeRecipe(JsonObject jsonObject) {
        this.type = ForgeRecipeType.valueOf(jsonObject.get("type").getAsString().toUpperCase(Locale.ROOT));
        this.duration = jsonObject.has("duration") ? jsonObject.get("duration").getAsLong() : -1L;
        JsonArray ingredients = jsonObject.get("ingredients").getAsJsonArray();
        HashMap<String, Ingredient> ingredientMap = new HashMap<String, Ingredient>();
        for (JsonElement jsonElement : ingredients) {
            Ingredient ingredient = Ingredient.of(jsonElement.getAsString());
            if (!ingredientMap.containsKey(ingredient.getId())) {
                ingredientMap.put(ingredient.getId(), ingredient);
                continue;
            }
            ingredientMap.put(ingredient.getId(), ((Ingredient)ingredientMap.remove(ingredient.getId())).merge(ingredient));
        }
        this.ingredients = new Ingredient[ingredientMap.size()];
        ingredientMap.values().toArray(this.ingredients);
        this.output = jsonObject.has("out") ? Ingredient.of(jsonObject.get("out").getAsString()) : null;
    }

    @Override
    public Ingredient[] getIngredients() {
        return this.ingredients;
    }

    @Override
    public Ingredient getOutput() {
        return this.output;
    }

    public long getPlayerDuration() {
        double playerDuration = this.duration;
        Optional<ProfileData> optionalProfile = ProfileStorage.getCurrentProfile();
        if (optionalProfile.isPresent()) {
            playerDuration *= optionalProfile.get().getHotmData().getQuickForgeMultiplier();
        }
        return (long)Math.ceil(playerDuration);
    }

    @Generated
    public ForgeRecipeType getType() {
        return this.type;
    }

    @Generated
    public long getDuration() {
        return this.duration;
    }

    public static enum ForgeRecipeType {
        FORGE,
        REFINE,
        CAST;

    }
}

