/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.repository.recipes;

import codes.cookies.mod.repository.Ingredient;
import codes.cookies.mod.repository.recipes.CraftRecipe;
import codes.cookies.mod.repository.recipes.ForgeRecipe;
import codes.cookies.mod.repository.recipes.RecipeType;
import codes.cookies.mod.utils.json.JsonUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;

public interface Recipe {
    public static final List<ForgeRecipe> ALL_FORGE_RECIPES = new LinkedList<ForgeRecipe>();
    public static final List<CraftRecipe> ALL_CRAFT_RECIPES = new LinkedList<CraftRecipe>();
    public static final List<Recipe> ALL_RECIPES = new LinkedList<Recipe>(){

        @Override
        public boolean add(Recipe recipe) {
            if (recipe instanceof ForgeRecipe) {
                ForgeRecipe forgeRecipe = (ForgeRecipe)recipe;
                ALL_FORGE_RECIPES.add(forgeRecipe);
            } else if (recipe instanceof CraftRecipe) {
                CraftRecipe craftRecipe = (CraftRecipe)recipe;
                ALL_CRAFT_RECIPES.add(craftRecipe);
            }
            return super.add(recipe);
        }
    };

    public static void load(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            System.err.println("Unable to load recipe list. (FILE_NOT_FOUND)");
            return;
        }
        try {
            String content = Files.readString(path, StandardCharsets.UTF_8);
            JsonArray jsonArray = (JsonArray)JsonUtils.CLEAN_GSON.fromJson(content, JsonArray.class);
            for (JsonElement jsonElement : jsonArray) {
                JsonObject jsonObject;
                JsonElement typeElement;
                if (!(jsonElement instanceof JsonObject) || !((typeElement = (jsonObject = (JsonObject)jsonElement).get("type")) instanceof JsonPrimitive)) continue;
                String type = typeElement.getAsString();
                RecipeType recipeType = RecipeType.valueOf(type.toUpperCase());
                Recipe apply = recipeType.getRecipeFunction().apply(jsonObject);
                Recipe.add(apply);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void add(Recipe recipe) {
        for (Ingredient ingredient : recipe.getIngredients()) {
            if (ingredient.getRepositoryItem() == null) continue;
            ingredient.getRepositoryItem().getUsedInRecipeAsIngredient().add(recipe);
        }
        ALL_RECIPES.add(recipe);
        if (recipe.getOutput() == null || recipe.getOutput().getRepositoryItem() == null) {
            return;
        }
        recipe.getOutput().getRepositoryItem().getRecipes().add(recipe);
    }

    public Ingredient[] getIngredients();

    public Ingredient getOutput();
}

