/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.repository.recipes.calculations;

import codes.cookies.mod.repository.Ingredient;
import codes.cookies.mod.repository.RepositoryItem;
import codes.cookies.mod.repository.recipes.Recipe;
import codes.cookies.mod.repository.recipes.calculations.CalculationContext;
import codes.cookies.mod.repository.recipes.calculations.RecipeCalculationResult;
import codes.cookies.mod.utils.Result;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;

public class RecipeCalculator {
    private static final String[] defaultBlacklist = new String[]{"hay_block", "wheat", "lapis_block", "lapis_lazuli", "redstone_block", "redstone", "diamond_block", "diamond", "emerald_block", "gold_block", "gold_ingot", "emerald", "coal_block", "coal", "iron_block", "iron_ingot", "slime_ball", "slime_block"};

    public static Result<RecipeCalculationResult, String> calculate(Recipe recipe) {
        return RecipeCalculator.calculate(recipe, new CalculationContext(defaultBlacklist));
    }

    public static Result<RecipeCalculationResult, String> calculate(RepositoryItem repositoryItem) {
        return RecipeCalculator.getBestRecipe(repositoryItem, false).map(RecipeCalculator::calculate).orElseGet(() -> Result.error("No recipe found :c"));
    }

    public static Result<RecipeCalculationResult, String> calculate(Recipe recipe, CalculationContext context) {
        ArrayList list = new ArrayList();
        for (Ingredient ingredient : recipe.getIngredients()) {
            if (ingredient.getRepositoryItem() == null) {
                list.add(ingredient);
                continue;
            }
            RepositoryItem repositoryItem = ingredient.getRepositoryItem();
            if (repositoryItem.getRecipes().isEmpty() || !context.canVisit(ingredient.getId())) {
                list.add(ingredient);
                continue;
            }
            if (context.hasBeenVisited(ingredient.getId())) continue;
            Optional<Recipe> bestRecipe = RecipeCalculator.getBestRecipe(repositoryItem, true);
            if (bestRecipe.isEmpty()) {
                return Result.error("Passed recipe empty check but has no recipe (%s)".formatted(ingredient.getId()));
            }
            Recipe subRecipe = bestRecipe.get();
            context.push(ingredient.getId());
            Result<RecipeCalculationResult, String> subCalculation = RecipeCalculator.calculate(subRecipe, context);
            if (subCalculation.isError()) {
                return subCalculation;
            }
            RecipeCalculationResult calculate = subCalculation.unbox();
            if (calculate == null) {
                return Result.error("Recipe calculation failed (%s)".formatted(ingredient.getId()));
            }
            context.pop();
            list.add(calculate.multiply((int)Math.ceil((double)ingredient.getAmount() / (double)subRecipe.getOutput().getAmount())));
        }
        return Result.success(new RecipeCalculationResult(recipe.getOutput(), list));
    }

    private static Optional<Recipe> getBestRecipe(RepositoryItem repositoryItem, boolean flip) {
        if (repositoryItem == null) {
            return Optional.empty();
        }
        return repositoryItem.getRecipes().stream().min(Comparator.comparingInt(recipe -> (flip ? -1 : 1) * recipe.getOutput().getAmount()));
    }
}

