/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.repository.recipes.calculations;

import codes.cookies.mod.repository.Ingredient;
import codes.cookies.mod.repository.recipes.Recipe;
import codes.cookies.mod.repository.recipes.calculations.RecipeCalculationResult;
import codes.cookies.mod.repository.recipes.calculations.RecipeCalculator;
import codes.cookies.mod.repository.recipes.calculations.RecipeResult;
import codes.cookies.mod.utils.Result;

public class RecipePrinter {
    public static String printRecipe(Recipe recipe) {
        Result<RecipeCalculationResult, String> calculate = RecipeCalculator.calculate(recipe);
        if (calculate.isError()) {
            return calculate.getError().orElse("An internal error occurred.");
        }
        return calculate.getResult().map(RecipePrinter::printRecipe).orElse("An internal error occurred.");
    }

    public static String printRecipe(RecipeCalculationResult recipeCalculationResult) {
        return RecipePrinter.printRecipe(recipeCalculationResult, 0);
    }

    private static String printRecipe(RecipeResult<?> calculationResult, int depth) {
        StringBuilder sb = new StringBuilder();
        if (calculationResult instanceof RecipeCalculationResult) {
            RecipeCalculationResult subResult = (RecipeCalculationResult)calculationResult;
            sb.append(" ".repeat(depth)).append(subResult.getIngredient().getAmount()).append("x ").append(subResult.getIngredient().getNameSafe()).append("\n");
            subResult.required.forEach(recipeResult -> sb.append(RecipePrinter.printRecipe(recipeResult, depth + 1)));
        } else if (calculationResult instanceof Ingredient) {
            Ingredient ingredient = (Ingredient)calculationResult;
            sb.append(" ".repeat(depth)).append(ingredient.getAmount()).append("x ").append(ingredient.getNameSafe()).append("\n");
        }
        return sb.toString();
    }
}

