/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.screen;

import codes.cookies.mod.screen.CookiesScreen;
import codes.cookies.mod.utils.maths.MathUtils;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;

public abstract class ScrollbarScreen
extends CookiesScreen {
    private static final class_2960 SCROLLER_TEXTURE = class_2960.method_60656((String)"container/creative_inventory/scroller");
    private static final int SCROLLBAR_WIDTH = 14;
    protected int scroll;
    private int scrollbarHeight;
    private int effectiveScrollbarHeight;
    private int scrollbarX;
    private int scrollbarY;
    private int maxScroll = 0;
    private float scrollStep = 0.0f;
    private boolean isScrolling;

    protected ScrollbarScreen(class_2561 title, int scrollbarHeight) {
        super(title);
        this.scrollbarHeight = scrollbarHeight;
        this.updateScrollbar(0, 0, 0);
    }

    public void updateScrollbar(int height, int x, int y) {
        this.scrollbarHeight = height;
        this.effectiveScrollbarHeight = this.scrollbarHeight - 15;
        this.scrollbarX = x;
        this.scrollbarY = y;
        this.updateScroll(this.maxScroll);
    }

    public void updateScroll(int maxScroll) {
        this.maxScroll = maxScroll;
        this.scrollStep = (float)this.effectiveScrollbarHeight / (float)Math.max(this.maxScroll, 1);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (ScrollbarScreen.isInBound((int)mouseX, (int)mouseY, this.scrollbarX, this.scrollbarY, 14, this.scrollbarHeight)) {
            this.isScrolling = true;
            return true;
        }
        this.isScrolling = false;
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isScrolling) {
            int start = this.scrollbarY;
            int end = start + this.scrollbarHeight;
            this.scroll = (int)((mouseY - (double)start - 7.5) / (double)((float)(end - start) - 15.0f) * (double)this.maxScroll);
            this.scroll = MathUtils.clamp(this.scroll, 0, this.maxScroll);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public void updateScrollbar(double verticalAmount) {
        this.scroll = MathUtils.clamp((int)((double)this.scroll - verticalAmount), 0, this.maxScroll);
    }

    protected void renderScrollbar(class_332 drawContext) {
        int scrollBarX = this.scrollbarX;
        int scrollBarY = this.scrollbarY;
        drawContext.method_52706(class_1921::method_62277, SCROLLER_TEXTURE, scrollBarX, MathUtils.clamp(scrollBarY + (int)((float)this.scroll * this.scrollStep), scrollBarY, scrollBarY + this.effectiveScrollbarHeight), 14, 15);
    }
}

