/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.screen.inventory;

import codes.cookies.mod.CookiesMod;
import codes.cookies.mod.repository.Ingredient;
import codes.cookies.mod.repository.RepositoryItem;
import codes.cookies.mod.repository.recipes.ForgeRecipe;
import codes.cookies.mod.repository.recipes.Recipe;
import codes.cookies.mod.screen.inventory.ForgeRecipeScreen;
import codes.cookies.mod.utils.TextUtils;
import codes.cookies.mod.utils.items.CookiesDataComponentTypes;
import codes.cookies.mod.utils.skyblock.InventoryUtils;
import codes.cookies.mod.utils.skyblock.inventories.ClientSideInventory;
import codes.cookies.mod.utils.skyblock.inventories.ItemBuilder;
import codes.cookies.mod.utils.skyblock.inventories.Position;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_9290;
import net.minecraft.class_9334;

public class ForgeRecipeOverviewScreen
extends ClientSideInventory {
    private static final Position LEFT_ARROW = new Position(5, 0);
    private static final Position RIGHT_ARROW = new Position(5, 8);
    private static final int ROWS = 6;

    public ForgeRecipeOverviewScreen() {
        super((class_2561)class_2561.method_43471((String)"cookies.screen.forge_recipe_overview"), 6);
        this.inventoryContents.fillBorders(outline);
        this.initPagination(Recipe.ALL_FORGE_RECIPES.stream().map(this::mapToItem).filter(Objects::nonNull).sorted(Comparator.comparing(this::sort, String::compareTo)).toList(), new Position(1, 1), new Position(4, 7), null);
        this.inventoryContents.set(new Position(0, 4), new ItemBuilder(class_1802.field_8187).setName((class_2561)TextUtils.translatable("cookies.screen.forge_recipe_overview", class_124.field_1060)).setLore(new class_2561[]{TextUtils.translatable("cookies.screen.forge_recipe_overview.view_all", class_124.field_1080)}).hideAdditionalTooltips().build());
        this.inventoryContents.set(new Position(5, 4), new ItemBuilder(class_1802.field_8077).hideTooltips().setName((class_2561)TextUtils.translatable("cookies.close", class_124.field_1061)).setClickRunnable(InventoryUtils.wrapWithSound(() -> ((ForgeRecipeOverviewScreen)this).method_25419())).hideAdditionalTooltips().build());
        this.inventoryContents.set(new Position(5, 3), new ItemBuilder(class_1802.field_8107).setName((class_2561)TextUtils.translatable("cookies.go_back", class_124.field_1060)).setLore(new class_2561[]{TextUtils.translatable("cookies.to_recipe_book", class_124.field_1080)}).setClickRunnable(this::openRecipeBook).build());
    }

    private class_1799 mapToItem(ForgeRecipe forgeRecipe) {
        Ingredient output = forgeRecipe.getOutput();
        RepositoryItem repositoryItem = output.getRepositoryItem();
        if (repositoryItem == null) {
            return null;
        }
        class_1799 itemStack = repositoryItem.constructItemStack();
        List texts = Optional.ofNullable((class_9290)itemStack.method_57824(class_9334.field_49632)).map(class_9290::comp_2400).orElse(null);
        if (texts == null) {
            return null;
        }
        ArrayList<class_5250> lore = new ArrayList<class_5250>(texts);
        lore.add(class_2561.method_43473());
        lore.add(TextUtils.translatable("cookies.click_to_view", class_124.field_1054).method_27693("!"));
        itemStack.method_57379(CookiesDataComponentTypes.CUSTOM_LORE, lore);
        itemStack.method_57379(CookiesDataComponentTypes.ITEM_CLICK_RUNNABLE, (Object)InventoryUtils.wrapWithSound(this.itemClicked(forgeRecipe)));
        return itemStack;
    }

    private String sort(class_1799 itemStack) {
        return itemStack.method_7964().getString();
    }

    private void openRecipeBook() {
        class_310.method_1551().field_1724.field_3944.method_45731("recipebook");
    }

    private Runnable itemClicked(ForgeRecipe forgeRecipe) {
        return () -> CookiesMod.openScreen(new ForgeRecipeScreen(forgeRecipe, this));
    }

    @Override
    public void method_25393() {
        super.method_25393();
    }

    @Override
    protected void paginationUpdate() {
        super.paginationUpdate();
        if (this.pagination.hasPreviousPage()) {
            this.inventoryContents.set(LEFT_ARROW, new ItemBuilder(class_1802.field_8107).setName((class_2561)TextUtils.translatable("cookies.page.previous", class_124.field_1060)).setLore(new class_2561[]{class_2561.method_43469((String)"cookies.page.with_number", (Object[])new Object[]{this.pagination.getCurrentPage() - 1}).method_27692(class_124.field_1054)}).setClickRunnable(InventoryUtils.wrapWithSound(this.pagination::previousPage)).build());
        } else {
            this.inventoryContents.set(LEFT_ARROW, outline);
        }
        if (this.pagination.hasNextPage()) {
            this.inventoryContents.set(RIGHT_ARROW, new ItemBuilder(class_1802.field_8107).setName((class_2561)TextUtils.translatable("cookies.page.next", class_124.field_1060)).setLore(new class_2561[]{class_2561.method_43469((String)"cookies.page.with_number", (Object[])new Object[]{this.pagination.getCurrentPage() + 1}).method_27692(class_124.field_1054)}).setClickRunnable(InventoryUtils.wrapWithSound(this.pagination::nextPage)).build());
        } else {
            this.inventoryContents.set(RIGHT_ARROW, outline);
        }
        this.inventoryTitle = class_2561.method_43469((String)"cookies.screen.forge_recipe_overview.title", (Object[])new Object[]{this.pagination.getCurrentPage(), this.pagination.getMaxPage()}).method_27692(class_124.field_1063);
    }
}

