/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.screen.inventory;

import codes.cookies.mod.CookiesMod;
import codes.cookies.mod.config.categories.CraftHelperCategory;
import codes.cookies.mod.features.misc.utils.ModifyRecipeScreen;
import codes.cookies.mod.features.misc.utils.crafthelper.CraftHelperManager;
import codes.cookies.mod.repository.Ingredient;
import codes.cookies.mod.repository.RepositoryItem;
import codes.cookies.mod.repository.recipes.ForgeRecipe;
import codes.cookies.mod.repository.recipes.Recipe;
import codes.cookies.mod.screen.inventory.ForgeRecipeOverviewScreen;
import codes.cookies.mod.utils.TextUtils;
import codes.cookies.mod.utils.items.CookiesDataComponentTypes;
import codes.cookies.mod.utils.skyblock.InventoryUtils;
import codes.cookies.mod.utils.skyblock.inventories.ClientSideInventory;
import codes.cookies.mod.utils.skyblock.inventories.ItemBuilder;
import codes.cookies.mod.utils.skyblock.inventories.Position;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class ForgeRecipeScreen
extends ClientSideInventory {
    private static final int ROWS = 6;
    private final ForgeRecipe recipe;
    private final class_437 previous;

    public ForgeRecipeScreen(ForgeRecipe recipe, class_437 previous) {
        super((class_2561)ForgeRecipeScreen.getName(recipe), 6);
        this.recipe = recipe;
        this.previous = previous;
        this.inventoryContents.fill(outline);
        this.setItems();
        this.inventoryContents.set(new Position(5, 4), new ItemBuilder(class_1802.field_8077).setName((class_2561)TextUtils.translatable("mco.selectServer.close", class_124.field_1061)).setClickRunnable(InventoryUtils.wrapWithSound(() -> ((ForgeRecipeScreen)this).method_25419())).hideAdditionalTooltips().build());
        this.inventoryContents.set(new Position(1, 4), new ItemBuilder(class_1802.field_8187).setName((class_2561)TextUtils.translatable("cookies.screen.forge_recipe_overview.recipe", class_124.field_1060)).setLore(new class_2561[]{TextUtils.literal("<-- ", class_124.field_1068).method_10852((class_2561)TextUtils.literal("Required items", class_124.field_1054)), TextUtils.literal("      Result item ", class_124.field_1054).method_10852((class_2561)TextUtils.literal(" -->", class_124.field_1068))}).build());
        if (CraftHelperCategory.enable) {
            class_1799 craftHelperSelect = ModifyRecipeScreen.CRAFT_HELPER_SELECT.method_7972();
            craftHelperSelect.method_57379(CookiesDataComponentTypes.ITEM_CLICK_RUNNABLE, (Object)InventoryUtils.wrapWithSound(this::setSelected, class_3417.field_14627, 1.0f, 0.5f));
            this.inventoryContents.set(new Position(3, 4), craftHelperSelect);
        }
        ItemBuilder goBack = new ItemBuilder(class_1802.field_8107).setName((class_2561)TextUtils.translatable("dataPack.validation.back", class_124.field_1060)).setClickRunnable(InventoryUtils.wrapWithSound(this::openForgeRecipes));
        if (previous instanceof ForgeRecipeOverviewScreen) {
            goBack.setLore(new class_2561[]{TextUtils.translatable("cookies.screen.forge_recipe_overview.back_to_forge_recipes", class_124.field_1080)});
        } else if (previous instanceof ForgeRecipeScreen) {
            ForgeRecipeScreen forgeRecipeScreen = (ForgeRecipeScreen)previous;
            goBack.setLore(new class_2561[]{TextUtils.literal("To ", class_124.field_1080).method_10852((class_2561)ForgeRecipeScreen.getName(forgeRecipeScreen.recipe).method_27692(class_124.field_1080))});
        } else {
            return;
        }
        this.inventoryContents.set(new Position(5, 3), goBack.build());
    }

    private static class_5250 getName(ForgeRecipe recipe) {
        return recipe.getOutput().getRepositoryItem().getName().method_27662().method_27693(" Recipe").method_27692(class_124.field_1063);
    }

    private void setItems() {
        for (int i = 0; i < this.recipe.getIngredients().length; ++i) {
            int row = i / 2;
            Ingredient ingredient = this.recipe.getIngredients()[i];
            Position position = new Position(1 + row, 1 + i % 2);
            class_1799 asItem = ingredient.getAsItem();
            if (ingredient.getRepositoryItem() != null) {
                RepositoryItem repositoryItem = ingredient.getRepositoryItem();
                Set<Recipe> recipes = repositoryItem.getRecipes();
                if (recipes.stream().anyMatch(ForgeRecipe.class::isInstance)) {
                    Optional<ForgeRecipe> first = recipes.stream().filter(ForgeRecipe.class::isInstance).map(ForgeRecipe.class::cast).findFirst();
                    ForgeRecipe forgeRecipe = first.orElseThrow();
                    asItem.method_57379(CookiesDataComponentTypes.ITEM_CLICK_RUNNABLE, (Object)InventoryUtils.wrapWithSound(this.clickedForgeRecipe(forgeRecipe)));
                } else if (!recipes.isEmpty()) {
                    asItem.method_57379(CookiesDataComponentTypes.ITEM_CLICK_RUNNABLE, (Object)InventoryUtils.wrapWithSound(this.clickedNonForge(repositoryItem.getInternalId())));
                }
            }
            this.inventoryContents.set(position, asItem);
        }
        this.inventoryContents.set(new Position(1, 7), this.recipe.getOutput().getRepositoryItem().constructItemStack());
    }

    private void setSelected() {
        CraftHelperManager.pushNewCraftHelperItem(this.recipe.getOutput().getRepositoryItemNotNull(), 1);
    }

    private void openForgeRecipes() {
        CookiesMod.openScreen(this.previous);
    }

    private Runnable clickedForgeRecipe(ForgeRecipe forgeRecipe) {
        return () -> CookiesMod.openScreen(new ForgeRecipeScreen(forgeRecipe, this));
    }

    private Runnable clickedNonForge(String internalId) {
        return () -> class_310.method_1551().field_1724.field_3944.method_45731("viewrecipe %s".formatted(internalId.toUpperCase()));
    }
}

