/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.screen.search;

import codes.cookies.mod.CookiesMod;
import codes.cookies.mod.data.profile.items.Item;
import codes.cookies.mod.data.profile.items.ItemCompound;
import codes.cookies.mod.data.profile.items.ItemSources;
import codes.cookies.mod.data.profile.items.sources.StorageItemSource;
import codes.cookies.mod.data.profile.sub.StorageData;
import codes.cookies.mod.screen.search.ItemSearchScreen;
import codes.cookies.mod.services.item.ItemSearchService;
import codes.cookies.mod.services.item.ItemServices;
import codes.cookies.mod.utils.TextUtils;
import codes.cookies.mod.utils.cookies.CookiesUtils;
import codes.cookies.mod.utils.items.CookiesDataComponentTypes;
import codes.cookies.mod.utils.skyblock.InventoryUtils;
import codes.cookies.mod.utils.skyblock.inventories.ClientSideInventory;
import codes.cookies.mod.utils.skyblock.inventories.ItemBuilder;
import codes.cookies.mod.utils.skyblock.inventories.Position;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class InspectItemScreen
extends ClientSideInventory {
    private static final Position LEFT_ARROW = new Position(5, 0);
    private static final Position RIGHT_ARROW = new Position(5, 8);
    private static final int ROWS = 6;
    @Nullable
    private final ItemSearchScreen itemSearchScreen;

    public InspectItemScreen(ItemCompound compound, @Nullable ItemSearchScreen itemSearchScreen) {
        super(compound.itemStack().method_7964(), 6);
        this.itemSearchScreen = itemSearchScreen;
        super.initPagination(compound.getUsedItems().stream().sorted(Comparator.comparing(item -> CookiesUtils.stripColor(item.itemStack().method_7964().getString()), String::compareToIgnoreCase).thenComparingInt(item -> item.source().ordinal()).thenComparingInt(this::ordered)).map(this::modifyItem).toList(), new Position(1, 1), new Position(4, 7), null);
        this.inventoryContents.fill(new ItemBuilder(class_1802.field_8157).hideAdditionalTooltips().hideTooltips().build());
        this.inventoryContents.set(new Position(5, 4), new ItemBuilder(class_1802.field_8107).setName("Back to overview").setClickRunnable(InventoryUtils.wrapWithSound(this::backToOverview)).build());
        this.drawBackground = false;
    }

    private int ordered(Item<?> item) {
        return switch (item.source()) {
            case ItemSources.STORAGE -> {
                StorageItemSource.Context data = (StorageItemSource.Context)item.data();
                yield (data.location() == StorageData.StorageLocation.BACKPACK ? 9 : 0) + data.page() + 1;
            }
            case ItemSources.INVENTORY -> (Integer)item.data();
            default -> 0;
        };
    }

    private class_1799 modifyItem(Item<?> item) {
        class_1799 copy = item.itemStack().method_7972();
        class_9290 loreComponent = (class_9290)copy.method_57824(class_9334.field_49632);
        ArrayList<Object> lore = loreComponent != null ? new ArrayList(loreComponent.comp_2400()) : new ArrayList<class_2561>();
        lore.add((class_2561)class_2561.method_43473());
        Object data = item.data();
        ItemCompound.CompoundType compoundType = ItemCompound.CompoundType.of(item.source(), data);
        ItemServices.appendMultiTooltip(compoundType, data, lore);
        lore.add((class_2561)class_2561.method_43471((String)"cookies.screen.item_search.remove_from_cache").method_27692(class_124.field_1061));
        copy.method_57379(CookiesDataComponentTypes.CUSTOM_LORE, lore);
        copy.method_57379(CookiesDataComponentTypes.ITEM_CLICK_CONSUMER, InventoryUtils.wrapWithSound(this.getItemClickConsumer(item, copy)));
        return copy;
    }

    private void backToOverview() {
        if (this.itemSearchScreen == null) {
            this.method_25419();
            return;
        }
        this.itemSearchScreen.updateInventory();
        CookiesMod.openScreen(this.itemSearchScreen);
    }

    private Consumer<Integer> getItemClickConsumer(Item<?> item, class_1799 copy) {
        return button -> this.onItemClick(item, copy, (Integer)button);
    }

    private void onItemClick(Item<?> item, class_1799 copy, Integer button) {
        if (button == 1) {
            item.source().getItemSource().remove(item);
            this.pagination.removeItem(copy);
        } else if (button == 0) {
            ItemSearchService.performAction(ItemCompound.CompoundType.of(item.source(), item.data()), item.data(), item);
            this.method_25419();
        }
    }

    @Override
    public void method_25393() {
        super.method_25393();
    }

    @Override
    protected void paginationUpdate() {
        super.paginationUpdate();
        if (this.pagination.hasPreviousPage()) {
            this.inventoryContents.set(LEFT_ARROW, new ItemBuilder(class_1802.field_8107).setName((class_2561)TextUtils.translatable("cookies.page.previous", class_124.field_1060)).setLore(new class_2561[]{class_2561.method_43469((String)"cookies.page.with_number", (Object[])new Object[]{this.pagination.getCurrentPage() - 1}).method_27692(class_124.field_1054)}).setClickRunnable(InventoryUtils.wrapWithSound(this.pagination::previousPage)).build());
        } else {
            this.inventoryContents.set(LEFT_ARROW, outline);
        }
        if (this.pagination.hasNextPage()) {
            this.inventoryContents.set(RIGHT_ARROW, new ItemBuilder(class_1802.field_8107).setName((class_2561)TextUtils.translatable("cookies.page.next", class_124.field_1060)).setLore(new class_2561[]{class_2561.method_43469((String)"cookies.page.with_number", (Object[])new Object[]{this.pagination.getCurrentPage() + 1}).method_27692(class_124.field_1054)}).setClickRunnable(InventoryUtils.wrapWithSound(this.pagination::nextPage)).build());
        } else {
            this.inventoryContents.set(RIGHT_ARROW, outline);
        }
        this.inventoryTitle = class_2561.method_43469((String)"cookies.screen.item_search.overview.title", (Object[])new Object[]{this.pagination.getCurrentPage(), this.pagination.getMaxPage()}).method_27692(class_124.field_1063);
    }

    @Override
    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
        if (this.itemSearchScreen != null) {
            this.itemSearchScreen.method_25394(context, 0, 0, delta);
        }
        this.method_52752(context);
        super.method_57734();
        super.method_25420(context, mouseX, mouseY, delta);
    }
}

