/*
 * Decompiled with CFR 0.152.
 */
package codes.cookies.mod.screen.search;

import codes.cookies.mod.repository.RepositoryItem;
import codes.cookies.mod.utils.skyblock.inventories.ItemBuilder;
import com.google.common.base.Predicates;
import java.util.Optional;
import java.util.function.Predicate;
import lombok.Generated;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;

public enum ItemSearchCategories {
    ALL(new class_1799((class_1935)class_1802.field_8270), (class_2561)class_2561.method_43471((String)"cookies.item_search.all"), (Predicate<RepositoryItem>)Predicates.alwaysTrue()),
    ARMOR(new class_1799((class_1935)class_1802.field_8873), (class_2561)class_2561.method_43471((String)"cookies.item_search.armor"), ItemSearchCategories.createCategoryPredicateWithDungeon("CHESTPLATE").or(ItemSearchCategories.createCategoryPredicateWithDungeon("BOOTS")).or(ItemSearchCategories.createCategoryPredicateWithDungeon("HELMET")).or(ItemSearchCategories.createCategoryPredicateWithDungeon("LEGGINGS"))),
    WEAPONS(new class_1799((class_1935)class_1802.field_22022), (class_2561)class_2561.method_43471((String)"cookies.item_search.weapons"), ItemSearchCategories.createCategoryPredicateWithDungeon("SWORD").or(ItemSearchCategories.createCategoryPredicate("FISHING WEAPON")).or(ItemSearchCategories.createCategoryPredicateWithDungeon("BOW")).or(ItemSearchCategories.createCategoryPredicate("WAND")).or(ItemSearchCategories.createCategoryPredicate("DUNGEON LONGSWORD"))),
    MATERIAL(new class_1799((class_1935)class_1802.field_8620), (class_2561)class_2561.method_43471((String)"cookies.item_search.material"), repositoryItem -> repositoryItem != null && repositoryItem.getUsedInRecipeAsIngredient().size() > 1 && repositoryItem.getCategory() == null),
    MINION(new ItemBuilder(class_1802.field_8575).setSkin("eyJ0aW1lc3RhbXAiOjE1NzY1MTMxOTQ4MDUsInByb2ZpbGVJZCI6ImRlNTcxYTEwMmNiODQ4ODA4ZmU3YzlmNDQ5NmVjZGFkIiwicHJvZmlsZU5hbWUiOiJNSEZfTWluZXNraW4iLCJzaWduYXR1cmVSZXF1aXJlZCI6dHJ1ZSwidGV4dHVyZXMiOnsiU0tJTiI6eyJ1cmwiOiJodHRwOi8vdGV4dHVyZXMubWluZWNyYWZ0Lm5ldC90ZXh0dXJlL2Y2ZDE4MDY4NGMzNTIxYzlmYzg5NDc4YmE0NDA1YWU5Y2U0OTdkYTgxMjRmYTBkYTVhMDEyNjQzMWM0Yjc4YzMifX19").build(), (class_2561)class_2561.method_43471((String)"cookies.item_search.minion"), repositoryItem -> repositoryItem != null && repositoryItem.getInternalId().matches(".*GENERATOR_\\d+"));

    public static final ItemSearchCategories[] VALUES;
    private final class_1799 display;
    private final class_2561 name;
    private final Predicate<RepositoryItem> itemPredicate;

    private static Predicate<RepositoryItem> createCategoryPredicateWithDungeon(String category) {
        Predicate<RepositoryItem> categoryPredicate = ItemSearchCategories.createCategoryPredicate(category);
        return categoryPredicate.or(ItemSearchCategories.createCategoryPredicate("DUNGEON " + category));
    }

    private static Predicate<RepositoryItem> createCategoryPredicate(String category) {
        return repositoryItem -> repositoryItem != null && Optional.ofNullable(repositoryItem.getCategory()).map(s -> s.equalsIgnoreCase(category)).orElse(false) != false;
    }

    @Generated
    private ItemSearchCategories(class_1799 display, class_2561 name, Predicate<RepositoryItem> itemPredicate) {
        this.display = display;
        this.name = name;
        this.itemPredicate = itemPredicate;
    }

    @Generated
    public class_1799 getDisplay() {
        return this.display;
    }

    @Generated
    public class_2561 getName() {
        return this.name;
    }

    @Generated
    public Predicate<RepositoryItem> getItemPredicate() {
        return this.itemPredicate;
    }

    static {
        VALUES = ItemSearchCategories.values();
    }
}

